/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.client.loader;

import edu.uiuc.ncsa.myproxy.oa4mp.client.ClientEnvironment;
import edu.uiuc.ncsa.myproxy.oa4mp.client.ClientLoaderInterface;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetConverter;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetSerializationKeys;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetStore;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.FSAssetStoreProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.MemoryAssetStore;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.MultiAssetStoreProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.SQLAssetStoreProvider;
import edu.uiuc.ncsa.security.core.configuration.Configurations;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEvent;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEventListener;
import edu.uiuc.ncsa.security.core.configuration.provider.TypedProvider;
import edu.uiuc.ncsa.security.core.exceptions.MyConfigurationException;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.delegation.client.DelegationService;
import edu.uiuc.ncsa.security.delegation.servlet.StorageConfigLoader;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPoolProvider;
import edu.uiuc.ncsa.security.util.ssl.SSLConfiguration;
import edu.uiuc.ncsa.security.util.ssl.SSLConfigurationUtil;
import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Provider;
import org.apache.commons.configuration.tree.ConfigurationNode;

public abstract class AbstractClientLoader<T extends ClientEnvironment>
extends StorageConfigLoader<T>
implements ClientLoaderInterface {
    public static final String ACCESS_TOKEN_ENDPOINT = "token";
    public static final String AUTHORIZE_ENDPOINT = "authorize";
    public static final String ASSET_ENDPOINT = "getcert";
    public static final String INITIATE_ENDPOINT = "initiate";
    public static final String USER_INFO_ENDPOINT = "userinfo";
    public static final long defaultCertLifetime = 864000L;
    protected Provider<AssetStore> assetStoreProvider;
    protected Provider<DelegationService> dsp;
    T loader = null;
    SSLConfiguration sslConfiguration = null;

    protected AbstractClientLoader(ConfigurationNode node) {
        super(node);
    }

    protected AbstractClientLoader(ConfigurationNode node, MyLoggingFacade logger) {
        super(node, logger);
    }

    public abstract AssetProvider getAssetProvider();

    protected Provider<AssetStore> getAssetStoreProvider() {
        if (this.assetStoreProvider == null) {
            MultiAssetStoreProvider masp = new MultiAssetStoreProvider(this.cn, this.isDefaultStoreDisabled(new boolean[0]), (MyLoggingFacade)this.loggerProvider.get());
            AssetConverter assetConverter = new AssetConverter(new AssetSerializationKeys(), this.getAssetProvider());
            this.assetStoreProvider = masp;
            masp.addListener((CfgEventListener)new FSAssetStoreProvider(this.cn, this.getAssetProvider(), assetConverter));
            masp.addListener((CfgEventListener)new SQLAssetStoreProvider(this.cn, "postgresql", (ConnectionPoolProvider<? extends ConnectionPool>)this.getPgConnectionPoolProvider(), this.getAssetProvider(), assetConverter));
            masp.addListener((CfgEventListener)new SQLAssetStoreProvider(this.cn, "mysql", (ConnectionPoolProvider<? extends ConnectionPool>)this.getMySQLConnectionPoolProvider(), this.getAssetProvider(), assetConverter));
            masp.addListener((CfgEventListener)new TypedProvider<MemoryAssetStore>(this.cn, "memoryStore", "assetStore"){

                public Object componentFound(CfgEvent configurationEvent) {
                    if (this.checkEvent(configurationEvent)) {
                        return this.get();
                    }
                    return null;
                }

                public MemoryAssetStore get() {
                    return new MemoryAssetStore(AbstractClientLoader.this.getAssetProvider());
                }
            });
        }
        return this.assetStoreProvider;
    }

    protected abstract Provider<DelegationService> getDSP();

    protected URI checkURI(String x, String componentName) {
        if (this.trivial(x)) {
            throw new MyConfigurationException("Error: There is no " + componentName + " URI specified.");
        }
        try {
            return new URI(x);
        }
        catch (URISyntaxException e) {
            throw new MyConfigurationException("Error: The specified " + componentName + " is not a valid URI", (Throwable)e);
        }
    }

    protected String getCfgValue(String key) {
        return Configurations.getNodeValue((ConfigurationNode)this.cn, (String)key);
    }

    protected String getSkin() {
        return this.getCfgValue("skin");
    }

    protected long getMaxAssetLifetime() {
        String x = this.getCfgValue("maxAssetLifetime");
        long y = 2592000000L;
        if (x == null || x.length() == 0) {
            return y;
        }
        try {
            y = Long.parseLong(x) * 1000L;
        }
        catch (NumberFormatException nfx) {
            // empty catch block
        }
        return y;
    }

    protected boolean isEnableAssetCleanup() {
        boolean doIt = false;
        try {
            doIt = Boolean.parseBoolean(this.getCfgValue("enableAssetCleanup"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return doIt;
    }

    protected URI createServiceURI(String foundURI, String baseUri, String serviceEndpoint) {
        if (!this.trivial(foundURI)) {
            return this.checkURI(foundURI, serviceEndpoint);
        }
        if (this.trivial(baseUri)) {
            throw new MyConfigurationException("Error: No base uri for " + serviceEndpoint + " found");
        }
        return this.checkURI(baseUri + (baseUri.endsWith("/") ? "" : "/") + serviceEndpoint, serviceEndpoint);
    }

    protected long checkCertLifetime() {
        String certLifetimeString = this.getCfgValue("lifetime");
        if (!this.trivial(certLifetimeString)) {
            try {
                return Long.parseLong(certLifetimeString);
            }
            catch (Throwable t) {
                this.myLogger.warn("Error: parsing default lifetime for cert:" + t.getMessage());
            }
        }
        return 864000L;
    }

    boolean trivial(String x) {
        return x == null || 0 == x.length();
    }

    protected String getId() {
        String id = this.getCfgValue("id");
        if (this.trivial(id)) {
            throw new MyConfigurationException("Error: there is no identifier specified.");
        }
        return id;
    }

    protected URI getCallback() {
        return this.checkURI(this.getCfgValue("callbackUri"), "callback");
    }

    protected void checkProtocol(String b) {
        if (b == null) {
            return;
        }
        if (!b.toLowerCase().startsWith("https")) {
            throw new IllegalArgumentException("Error: the base uri must be https. You have \"" + b + "\"");
        }
    }

    protected String getBaseURI() {
        String b = this.getCfgValue("serviceUri");
        if (b == null || b.length() == 0) {
            throw new IllegalArgumentException("Error: no base uri specified in the configuration file");
        }
        this.checkProtocol(b);
        return b;
    }

    protected URI getAccessTokenURI() {
        return this.createServiceURI(this.getCfgValue("accessTokenUri"), this.getBaseURI(), ACCESS_TOKEN_ENDPOINT);
    }

    protected URI getAssetURI() {
        String x = this.getCfgValue("assetUri");
        this.checkProtocol(x);
        return this.createServiceURI(x, this.getBaseURI(), ASSET_ENDPOINT);
    }

    protected URI getAuthorizeURI() {
        String x = this.getCfgValue("authorizeUri");
        this.checkProtocol(x);
        return this.createServiceURI(x, this.getBaseURI(), AUTHORIZE_ENDPOINT);
    }

    protected URI getInitiateURI() {
        String x = this.getCfgValue("initiateUri");
        this.checkProtocol(x);
        return this.createServiceURI(x, this.getBaseURI(), INITIATE_ENDPOINT);
    }

    public T load() {
        if (this.loader == null) {
            this.loader = (ClientEnvironment)this.createInstance();
        }
        return this.loader;
    }

    public SSLConfiguration getSSLConfiguration() {
        if (this.sslConfiguration == null) {
            this.sslConfiguration = SSLConfigurationUtil.getSSLConfiguration((ConfigurationNode)this.cn);
        }
        return this.sslConfiguration;
    }
}

