/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.client.storage;

import edu.uiuc.ncsa.myproxy.oa4mp.client.Asset;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetSerializationKeys;
import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.storage.data.ConversionMap;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.data.SerializationKeys;
import edu.uiuc.ncsa.security.util.pkcs.CertUtil;
import edu.uiuc.ncsa.security.util.pkcs.KeyUtil;
import edu.uiuc.ncsa.security.util.pkcs.MyPKCS10CertRequest;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class AssetConverter
extends MapConverter<Asset> {
    public AssetConverter(SerializationKeys keys, IdentifiableProvider<Asset> provider) {
        super(keys, provider);
    }

    protected AssetSerializationKeys getAR() {
        return (AssetSerializationKeys)this.keys;
    }

    public Asset fromMap(ConversionMap<String, Object> map, Asset asset) {
        super.fromMap(map, (Identifiable)asset);
        asset.setUsername(map.getString((Object)this.getAR().username(new String[0])));
        try {
            String rawCert = map.getString((Object)this.getAR().certificates(new String[0]));
            if (rawCert != null && 0 < rawCert.length()) {
                asset.setCertificates(CertUtil.fromX509PEM((String)rawCert));
            }
        }
        catch (CertificateException e) {
            throw new GeneralException("Error: could not create certificate", (Throwable)e);
        }
        String temp = map.getString((Object)this.getAR().privateKey(new String[0]));
        if (temp != null) {
            asset.setPrivateKey(KeyUtil.fromPKCS8PEM((String)temp));
        }
        asset.setRedirect(map.getURI((Object)this.getAR().redirect(new String[0])));
        asset.setCreationTime(map.getDate((Object)this.getAR().creationTime(new String[0])));
        String rawCertReq = map.getString((Object)this.getAR().certReq(new String[0]));
        if (rawCertReq != null) {
            asset.setCertReq(CertUtil.fromStringToCertReq((String)rawCertReq));
        }
        return asset;
    }

    public void toMap(Asset asset, ConversionMap<String, Object> map) {
        super.toMap((Identifiable)asset, map);
        if (asset.getPrivateKey() != null) {
            map.put((Object)this.getAR().privateKey(new String[0]), (Object)KeyUtil.toPKCS8PEM((PrivateKey)asset.getPrivateKey()));
        }
        if (asset.getRedirect() != null) {
            map.put((Object)this.getAR().redirect(new String[0]), (Object)asset.getRedirect().toString());
        }
        if (asset.getCertificates() != null) {
            map.put((Object)this.getAR().certificates(new String[0]), (Object)CertUtil.toPEM((X509Certificate[])asset.getCertificates()));
        }
        if (asset.getUsername() != null && 0 < asset.getUsername().length()) {
            map.put((Object)this.getAR().username(new String[0]), (Object)asset.getUsername());
        }
        if (asset.getCreationTime() != null) {
            map.put((Object)this.getAR().creationTime(new String[0]), (Object)asset.getCreationTime());
        }
        if (asset.getCertReq() != null) {
            map.put((Object)this.getAR().certReq(new String[0]), (Object)CertUtil.fromCertReqToString((MyPKCS10CertRequest)asset.getCertReq()));
        }
    }
}

