package edu.uiuc.ncsa.myproxy.oa4mp.client.storage;

import edu.uiuc.ncsa.myproxy.oa4mp.client.Asset;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;

/**
 * The top-level abstract class for storing {@link Asset}s. This is a map that is keyed off an
 * {@link edu.uiuc.ncsa.security.core.Identifier} generated by the client. The only requirement on the identifier is
 * it be a URI, otherwise it may be arbitrary.
 * <h2>Usage</h2>
 * A store is specified in the client configuration.
 * <h2>Lifecycle</h2>
 * Once the asset store is specified in the configuration, the system will instantitate it and manage it.
 * It is accessible from the {@link edu.uiuc.ncsa.myproxy.oa4mp.client.ClientEnvironment#getAssetStore()}
 * Note that if there is no asset store specified, then calls for the store return a null,
 * therefore implementors should check if there has been a store with the
 * {@link edu.uiuc.ncsa.myproxy.oa4mp.client.ClientEnvironment#hasAssetStore()} method first.
 * <p>Created by Jeff Gaynor<br>
 * on 1/23/13 at  4:42 PM
 */
public interface AssetStore extends Store<Asset> {
    /**
     * Simplifying calls. These should simply convert the string to an identifier.
     * @param identifier
     * @return
     */
    public Asset get(String identifier);
    public void save(String identifier, Asset v);

    /**
     * Part of solution to OAUTH-146: JSESSIONID bug causes session crossover if
     * users have repeated failed attempts to get a cert and keep opening a
     * new browser window each time.
     * @param token
     * @return
     */
    public Asset getByToken(Identifier token);
    public void putByToken(Asset asset);
}
