/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.client.servlet;

import edu.uiuc.ncsa.myproxy.oa4mp.client.servlet.ClientServlet;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.servlet.ExceptionHandler;
import edu.uiuc.ncsa.security.servlet.JSPUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ClientExceptionHandler
implements ExceptionHandler {
    MyLoggingFacade logger;
    protected ClientServlet clientServlet;

    public MyLoggingFacade getLogger() {
        return this.logger;
    }

    public ClientExceptionHandler(ClientServlet clientServlet, MyLoggingFacade logger) {
        this.logger = logger;
        this.clientServlet = clientServlet;
    }

    public void handleException(Throwable t, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        t.printStackTrace();
        if (t.getCause() == null) {
            this.clientServlet.warn("2.a. Exception from the server: (no other cause)");
            request.setAttribute("cause", (Object)"(none)");
            request.setAttribute("stackTrace", (Object)"(none)");
        } else {
            this.clientServlet.warn("2.a. Exception from the server: " + t.getCause().getMessage());
            request.setAttribute("cause", (Object)t.getCause().getMessage());
            request.setAttribute("stackTrace", (Object)t.getCause());
        }
        this.clientServlet.error("Exception while trying to get cert. message:" + t.getMessage());
        if (t instanceof RuntimeException) {
            String path = this.clientServlet.getServletContext().getContextPath();
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            request.setAttribute("action", (Object)path);
            request.setAttribute("message", (Object)t.getMessage());
            JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)this.clientServlet.getCE().getErrorPagePath());
            return;
        }
        throw new ServletException("Error", t);
    }
}

