/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.client.loader;

import edu.uiuc.ncsa.myproxy.oa4mp.client.ClientEnvironment;
import edu.uiuc.ncsa.myproxy.oa4mp.client.servlet.ClientExceptionHandler;
import edu.uiuc.ncsa.myproxy.oa4mp.client.servlet.ClientServlet;
import edu.uiuc.ncsa.security.core.cache.Cleanup;
import edu.uiuc.ncsa.security.core.cache.RetentionPolicy;
import edu.uiuc.ncsa.security.core.cache.ValidTimestampPolicy;
import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.servlet.AbstractServlet;
import edu.uiuc.ncsa.security.servlet.ExceptionHandler;
import edu.uiuc.ncsa.security.servlet.Initialization;
import edu.uiuc.ncsa.security.storage.sql.SQLStore;
import java.sql.SQLException;
import java.util.Map;
import javax.servlet.ServletException;

public class ClientServletInitializer
implements Initialization {
    protected ExceptionHandler exceptionHandler;
    protected boolean hasRun = false;
    AbstractEnvironment environment;
    AbstractServlet servlet;

    public ExceptionHandler getExceptionHandler() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new ClientExceptionHandler((ClientServlet)this.getServlet(), this.getEnvironment().getMyLogger());
        }
        return this.exceptionHandler;
    }

    public AbstractEnvironment getEnvironment() {
        return this.environment;
    }

    public void init() throws ServletException {
        if (this.hasRun) {
            return;
        }
        this.hasRun = true;
        MyLoggingFacade logger = this.getEnvironment().getMyLogger();
        ClientEnvironment ce = (ClientEnvironment)this.getEnvironment();
        if (ce.hasAssetStore()) {
            if (ce.getAssetStore() instanceof SQLStore) {
                SQLStore sqlStore = (SQLStore)ce.getAssetStore();
                try {
                    sqlStore.checkTable();
                    sqlStore.checkColumns();
                }
                catch (SQLException sqlX) {
                    logger.warn("Could not update store table:" + sqlX.getMessage());
                }
            }
            Cleanup assetCleanup = ClientServlet.assetCleanup;
            if (ce.isEnableAssetCleanup() && assetCleanup == null) {
                assetCleanup = new Cleanup(logger);
                assetCleanup.setStopThread(false);
                assetCleanup.setMap((Map)((Object)ce.getAssetStore()));
                assetCleanup.addRetentionPolicy((RetentionPolicy)new ValidTimestampPolicy(ce.getMaxAssetLifetime()));
                logger.info("Starting asset cleanup thread");
                assetCleanup.start();
                ClientServlet.assetCleanup = assetCleanup;
            }
        } else {
            logger.info("No assets store, so no cleanup possible.");
        }
    }

    public void setEnvironment(AbstractEnvironment environment) {
        this.environment = environment;
    }

    public AbstractServlet getServlet() {
        return this.servlet;
    }

    public void setServlet(AbstractServlet servlet) {
        this.servlet = servlet;
    }
}

