/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.client.storage;

import edu.uiuc.ncsa.myproxy.oa4mp.client.Asset;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetStore;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetStoreUtil;
import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.storage.FileStore;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import java.io.File;
import java.io.IOException;

public class FSAssetStore
extends FileStore<Asset>
implements AssetStore {
    public FSAssetStore(File file, IdentifiableProvider idp, MapConverter cp, boolean removeEmptyFiles) {
        super(file, idp, cp, removeEmptyFiles);
    }

    public FSAssetStore(File storeDirectory, File indexDirectory, IdentifiableProvider identifiableProvider, MapConverter converter, boolean removeEmptyFiles) {
        super(storeDirectory, indexDirectory, identifiableProvider, converter, removeEmptyFiles);
    }

    @Override
    public Asset get(String identifier) {
        return AssetStoreUtil.get(identifier, this);
    }

    @Override
    public void save(String identifier, Asset identifiable) {
        AssetStoreUtil.save(identifier, identifiable, this);
    }

    public void realSave(boolean checkExists, Asset t) {
        super.realSave(checkExists, (Identifiable)t);
        try {
            if (t.getToken() != null) {
                this.createIndexEntry(t.getToken().toString(), t.getIdentifierString());
            }
        }
        catch (IOException e) {
            throw new GeneralException("Error serializing item " + (Object)((Object)t) + "to file ");
        }
    }

    @Override
    public Asset getByToken(Identifier token) {
        return (Asset)this.getIndexEntry(token.toString());
    }

    @Override
    public void putByToken(Asset asset) {
        this.realSave(false, asset);
    }
}

