/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.client.storage;

import edu.uiuc.ncsa.myproxy.oa4mp.client.Asset;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetConverter;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetSerializationKeys;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetStore;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetStoreUtil;
import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.XMLConverter;
import edu.uiuc.ncsa.security.storage.MemoryStore;
import java.util.HashMap;

public class MemoryAssetStore
extends MemoryStore<Asset>
implements AssetStore {
    HashMap<Identifier, Asset> tokenCache = new HashMap();

    public MemoryAssetStore(IdentifiableProvider<Asset> identifiableProvider) {
        super(identifiableProvider);
    }

    @Override
    public Asset get(String identifier) {
        return AssetStoreUtil.get(identifier, this);
    }

    @Override
    public void save(String identifier, Asset v) {
        AssetStoreUtil.save(identifier, v, this);
    }

    @Override
    public Asset getByToken(Identifier token) {
        return this.tokenCache.get(token);
    }

    @Override
    public void putByToken(Asset asset) {
        this.tokenCache.put(asset.getToken(), asset);
    }

    public void save(Asset value) {
        super.save((Identifiable)value);
        if (value.getToken() != null) {
            this.putByToken(value);
        }
    }

    public XMLConverter<Asset> getXMLConverter() {
        return new AssetConverter(new AssetSerializationKeys(), (IdentifiableProvider<Asset>)this.identifiableProvider);
    }
}

