/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection;

import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.util.ToolRunner;

public interface DocnoMapping {
    public int getDocno(String var1);

    public String getDocid(int var1);

    public void loadMapping(Path var1, FileSystem var2) throws IOException;

    public Builder getBuilder();

    public static class BuilderUtils {
        public static final String COLLECTION_OPTION = "collection";
        public static final String MAPPING_OPTION = "docnoMapping";
        public static final String FORMAT_OPTION = "inputFormat";

        public static DefaultBuilderOptions parseDefaultOptions(String[] args) {
            CommandLine cmdline;
            Options options = new Options();
            OptionBuilder.withArgName((String)"path");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"(required) collection path");
            options.addOption(OptionBuilder.create((String)COLLECTION_OPTION));
            OptionBuilder.withArgName((String)"path");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"(required) output DocnoMapping path");
            options.addOption(OptionBuilder.create((String)MAPPING_OPTION));
            OptionBuilder.withArgName((String)"class");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"(optional) fully-qualified Hadoop InputFormat");
            options.addOption(OptionBuilder.create((String)FORMAT_OPTION));
            GnuParser parser = new GnuParser();
            try {
                cmdline = parser.parse(options, args);
            }
            catch (ParseException exp) {
                System.err.println("Error parsing command line: " + exp.getMessage());
                return null;
            }
            if (!cmdline.hasOption(COLLECTION_OPTION) || !cmdline.hasOption(MAPPING_OPTION)) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(DefaultBuilderOptions.class.getName(), options);
                ToolRunner.printGenericCommandUsage((PrintStream)System.out);
                return null;
            }
            DefaultBuilderOptions parsedOptions = new DefaultBuilderOptions();
            parsedOptions.inputFormat = SequenceFileInputFormat.class;
            if (cmdline.hasOption(FORMAT_OPTION)) {
                try {
                    parsedOptions.inputFormat = Class.forName(cmdline.getOptionValue(FORMAT_OPTION));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            parsedOptions.collection = cmdline.getOptionValue(COLLECTION_OPTION);
            parsedOptions.docnoMapping = cmdline.getOptionValue(MAPPING_OPTION);
            return parsedOptions;
        }
    }

    public static class DefaultBuilderOptions {
        public Class<? extends InputFormat> inputFormat;
        public String collection;
        public String docnoMapping;
    }

    public static interface Builder {
        public int build(Path var1, Path var2, Configuration var3) throws IOException;
    }
}

