/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.log4j.Logger;

public class XMLInputFormat
extends TextInputFormat {
    public static final String START_TAG_KEY = "xmlinput.start";
    public static final String END_TAG_KEY = "xmlinput.end";

    public RecordReader<LongWritable, Text> createRecordReader(InputSplit split, TaskAttemptContext context) {
        return new XMLRecordReader();
    }

    public static class XMLRecordReader
    extends RecordReader<LongWritable, Text> {
        private static final Logger LOG = Logger.getLogger(XMLRecordReader.class);
        private byte[] startTag;
        private byte[] endTag;
        private long start;
        private long end;
        private long pos;
        private DataInputStream fsin = null;
        private DataOutputBuffer buffer = new DataOutputBuffer();
        private long recordStartPos;
        private final LongWritable key = new LongWritable();
        private final Text value = new Text();

        public void initialize(InputSplit input, TaskAttemptContext context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            if (conf.get(XMLInputFormat.START_TAG_KEY) == null || conf.get(XMLInputFormat.END_TAG_KEY) == null) {
                throw new RuntimeException("Error! XML start and end tags unspecified!");
            }
            this.startTag = conf.get(XMLInputFormat.START_TAG_KEY).getBytes("utf-8");
            this.endTag = conf.get(XMLInputFormat.END_TAG_KEY).getBytes("utf-8");
            FileSplit split = (FileSplit)input;
            this.start = split.getStart();
            Path file = split.getPath();
            CompressionCodecFactory compressionCodecs = new CompressionCodecFactory(conf);
            CompressionCodec codec = compressionCodecs.getCodec(file);
            FileSystem fs = file.getFileSystem(conf);
            if (codec != null) {
                LOG.info((Object)("Reading compressed file " + file + "..."));
                this.fsin = new DataInputStream((InputStream)codec.createInputStream((InputStream)fs.open(file)));
                this.end = Long.MAX_VALUE;
            } else {
                LOG.info((Object)("Reading uncompressed file " + file + "..."));
                FSDataInputStream fileIn = fs.open(file);
                fileIn.seek(this.start);
                this.fsin = fileIn;
                this.end = this.start + split.getLength();
            }
            this.recordStartPos = this.start;
            this.pos = this.start;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean nextKeyValue() throws IOException, InterruptedException {
            if (this.pos < this.end && this.readUntilMatch(this.startTag, false)) {
                this.recordStartPos = this.pos - (long)this.startTag.length;
                try {
                    this.buffer.write(this.startTag);
                    if (this.readUntilMatch(this.endTag, true)) {
                        this.key.set(this.recordStartPos);
                        this.value.set(this.buffer.getData(), 0, this.buffer.getLength());
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    if (this.fsin instanceof Seekable && this.pos != ((Seekable)this.fsin).getPos()) {
                        throw new RuntimeException("bytes consumed error!");
                    }
                    this.buffer.reset();
                }
            }
            return false;
        }

        public LongWritable getCurrentKey() throws IOException, InterruptedException {
            return this.key;
        }

        public Text getCurrentValue() throws IOException, InterruptedException {
            return this.value;
        }

        public void close() throws IOException {
            this.fsin.close();
        }

        public float getProgress() throws IOException {
            return (float)(this.pos - this.start) / (float)(this.end - this.start);
        }

        private boolean readUntilMatch(byte[] match, boolean withinBlock) throws IOException {
            int i = 0;
            do {
                int b = this.fsin.read();
                ++this.pos;
                if (b == -1) {
                    return false;
                }
                if (withinBlock) {
                    this.buffer.write(b);
                }
                if (b == match[i]) {
                    if (++i < match.length) continue;
                    return true;
                }
                i = 0;
            } while (withinBlock || i != 0 || this.pos < this.end);
            return false;
        }
    }
}

