/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.clue;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import edu.umd.cloud9.collection.DocnoMapping;
import edu.umd.cloud9.collection.clue.ClueWarcDocnoMapping;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class ClueWarcDocnoMappingBuilder
extends Configured
implements Tool,
DocnoMapping.Builder {
    private static final Logger LOG = Logger.getLogger(ClueWarcDocnoMappingBuilder.class);

    @Override
    public int build(Path src, Path dest, Configuration conf) throws IOException {
        super.setConf(conf);
        return this.run(new String[]{"-collection=" + src.toString(), "-docnoMapping=" + dest.toString()});
    }

    public int run(String[] args) throws IOException {
        DocnoMapping.DefaultBuilderOptions options = DocnoMapping.BuilderUtils.parseDefaultOptions(args);
        if (options == null) {
            return -1;
        }
        LOG.info((Object)("Tool name: " + ClueWarcDocnoMappingBuilder.class.getSimpleName()));
        LOG.info((Object)(" - input path: " + options.collection));
        LOG.info((Object)(" - output file: " + options.docnoMapping));
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        FSDataOutputStream out = fs.create(new Path(options.docnoMapping), true);
        final InputStream in = ClueWarcDocnoMapping.class.getResourceAsStream("docno.mapping");
        List lines = CharStreams.readLines((InputSupplier)CharStreams.newReaderSupplier((InputSupplier)new InputSupplier<InputStream>(){

            public InputStream getInput() throws IOException {
                return in;
            }
        }, (Charset)Charsets.UTF_8));
        out.write((Joiner.on((String)"\n").join((Iterable)lines) + "\n").getBytes());
        out.close();
        return 0;
    }

    public static void main(String[] args) throws Exception {
        LOG.info((Object)("Running " + ClueWarcDocnoMappingBuilder.class.getCanonicalName() + " with args " + Arrays.toString(args)));
        ToolRunner.run((Tool)new ClueWarcDocnoMappingBuilder(), (String[])args);
    }
}

