/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.clue;

import edu.umd.cloud9.collection.clue.ClueWarcDocnoMapping;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;

public class ClueWarcDocnoMappingTest {
    @org.junit.Test
    public void testDocidToDocno() throws Exception {
        ClueWarcDocnoMapping mapping = new ClueWarcDocnoMapping();
        mapping.loadMapping(new Path("etc/Clue-English-docno.mapping"), FileSystem.get((Configuration)new Configuration()));
        Assert.assertEquals((long)1L, (long)mapping.getDocno("clueweb09-en0000-00-00000"));
        Assert.assertEquals((long)28335180L, (long)mapping.getDocno("clueweb09-en0007-91-00000"));
        Assert.assertEquals((long)28378418L, (long)mapping.getDocno("clueweb09-en0007-91-43238"));
        Assert.assertEquals((long)28378419L, (long)mapping.getDocno("clueweb09-en0007-92-00000"));
        Assert.assertEquals((long)44262895L, (long)mapping.getDocno("clueweb09-enwp00-00-00000"));
        Assert.assertEquals((long)50220424L, (long)mapping.getDocno("clueweb09-en0012-00-00000"));
        Assert.assertEquals((long)140950355L, (long)mapping.getDocno("clueweb09-en0038-18-42833"));
        Assert.assertEquals((long)503903810L, (long)mapping.getDocno("clueweb09-en0133-99-55739"));
    }

    @org.junit.Test
    public void testDocnoToDocid() throws Exception {
        ClueWarcDocnoMapping mapping = new ClueWarcDocnoMapping();
        mapping.loadMapping(new Path("etc/Clue-English-docno.mapping"), FileSystem.get((Configuration)new Configuration()));
        Assert.assertEquals((Object)"clueweb09-en0000-00-00000", (Object)mapping.getDocid(1));
        Assert.assertEquals((Object)"clueweb09-en0007-91-00000", (Object)mapping.getDocid(28335180));
        Assert.assertEquals((Object)"clueweb09-en0007-91-43238", (Object)mapping.getDocid(28378418));
        Assert.assertEquals((Object)"clueweb09-en0007-92-00000", (Object)mapping.getDocid(28378419));
        Assert.assertEquals((Object)"clueweb09-enwp00-00-00000", (Object)mapping.getDocid(44262895));
        Assert.assertEquals((Object)"clueweb09-en0012-00-00000", (Object)mapping.getDocid(50220424));
        Assert.assertEquals((Object)"clueweb09-en0038-18-42833", (Object)mapping.getDocid(140950355));
        Assert.assertEquals((Object)"clueweb09-en0133-99-55739", (Object)mapping.getDocid(503903810));
    }

    public static Test suite() {
        return new JUnit4TestAdapter(ClueWarcDocnoMappingTest.class);
    }
}

