/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.clue;

import edu.umd.cloud9.collection.Indexable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ClueWarcRecord
extends Indexable {
    public static String WARC_VERSION = "WARC/0.18";
    public static String WARC_VERSION_LINE = "WARC/0.18\n";
    private static String NEWLINE = "\n";
    private static byte MASK_THREE_BYTE_CHAR = (byte)-32;
    private static byte MASK_TWO_BYTE_CHAR = (byte)-64;
    private static byte MASK_TOPMOST_BIT = (byte)-128;
    private static byte MASK_BOTTOM_SIX_BITS = (byte)31;
    private static byte MASK_BOTTOM_FIVE_BITS = (byte)63;
    private static byte MASK_BOTTOM_FOUR_BITS = (byte)15;
    private WarcHeader warcHeader = new WarcHeader();
    private byte[] warcContent = null;
    private String warcFilePath = "";

    private static String readLineFromInputStream(DataInputStream in) throws IOException {
        StringBuilder retString = new StringBuilder();
        boolean keepReading = true;
        try {
            do {
                byte secondByte;
                char thisChar = '\u0000';
                byte readByte = in.readByte();
                if ((readByte & MASK_THREE_BYTE_CHAR) == MASK_THREE_BYTE_CHAR) {
                    if (in.available() < 2) {
                        retString.append((char)readByte);
                        int numAvailable = in.available();
                        for (int i = 0; i < numAvailable; ++i) {
                            retString.append((char)in.readByte());
                        }
                        continue;
                    }
                    secondByte = in.readByte();
                    byte thirdByte = in.readByte();
                    if ((secondByte & MASK_TOPMOST_BIT) != MASK_TOPMOST_BIT || (thirdByte & MASK_TOPMOST_BIT) != MASK_TOPMOST_BIT) {
                        retString.append((char)readByte);
                        retString.append((char)secondByte);
                        retString.append((char)thirdByte);
                        continue;
                    }
                    int finalVal = (thirdByte & MASK_BOTTOM_FIVE_BITS) + 64 * (secondByte & MASK_BOTTOM_FIVE_BITS) + 4096 * (readByte & MASK_BOTTOM_FOUR_BITS);
                    thisChar = (char)finalVal;
                } else if ((readByte & MASK_TWO_BYTE_CHAR) == MASK_TWO_BYTE_CHAR) {
                    if (in.available() < 1) {
                        retString.append((char)readByte);
                        continue;
                    }
                    secondByte = in.readByte();
                    if ((secondByte & MASK_TOPMOST_BIT) != MASK_TOPMOST_BIT) {
                        retString.append((char)readByte);
                        retString.append((char)secondByte);
                        continue;
                    }
                    int finalVal = (secondByte & MASK_BOTTOM_FIVE_BITS) + 64 * (readByte & MASK_BOTTOM_SIX_BITS);
                    thisChar = (char)finalVal;
                } else {
                    thisChar = (char)readByte;
                }
                if (thisChar == '\n') {
                    keepReading = false;
                    continue;
                }
                retString.append(thisChar);
            } while (keepReading);
        }
        catch (EOFException eofEx) {
            return null;
        }
        if (retString.length() == 0) {
            return "";
        }
        return retString.toString();
    }

    private static byte[] readNextRecord(DataInputStream in, StringBuffer headerBuffer) throws IOException {
        if (in == null) {
            return null;
        }
        if (headerBuffer == null) {
            return null;
        }
        String line = null;
        boolean foundMark = false;
        boolean inHeader = true;
        byte[] retContent = null;
        while (!foundMark && (line = ClueWarcRecord.readLineFromInputStream(in)) != null) {
            if (!line.startsWith(WARC_VERSION)) continue;
            foundMark = true;
        }
        if (!foundMark) {
            return null;
        }
        int contentLength = -1;
        boolean foundContentLength = false;
        while (!foundContentLength && inHeader && (line = ClueWarcRecord.readLineFromInputStream(in)) != null) {
            if (line.trim().length() == 0 && foundContentLength) {
                inHeader = false;
                continue;
            }
            headerBuffer.append(line);
            headerBuffer.append(NEWLINE);
            String[] thisHeaderPieceParts = line.split(":", 2);
            if (thisHeaderPieceParts.length != 2 || !thisHeaderPieceParts[0].toLowerCase().startsWith("content-length")) continue;
            foundContentLength = true;
            try {
                contentLength = Integer.parseInt(thisHeaderPieceParts[1].trim());
            }
            catch (NumberFormatException nfEx) {
                contentLength = -1;
            }
        }
        if (contentLength < 0) {
            return null;
        }
        retContent = new byte[contentLength];
        int totalWant = contentLength;
        int totalRead = 0;
        while (totalRead < contentLength) {
            try {
                int numRead = in.read(retContent, totalRead, totalWant);
                if (numRead < 0) {
                    return null;
                }
                totalWant = contentLength - (totalRead += numRead);
            }
            catch (EOFException eofEx) {
                if (totalRead > 0) {
                    byte[] newReturn = new byte[totalRead];
                    System.arraycopy(retContent, 0, newReturn, 0, totalRead);
                    return newReturn;
                }
                return null;
            }
        }
        return retContent;
    }

    public static ClueWarcRecord readNextWarcRecord(DataInputStream in) throws IOException {
        StringBuffer recordHeader = new StringBuffer();
        byte[] recordContent = ClueWarcRecord.readNextRecord(in, recordHeader);
        if (recordContent == null) {
            return null;
        }
        String thisHeaderString = recordHeader.toString();
        String[] headerLines = thisHeaderString.split(NEWLINE);
        ClueWarcRecord retRecord = new ClueWarcRecord();
        for (int i = 0; i < headerLines.length; ++i) {
            String[] pieces = headerLines[i].split(":", 2);
            if (pieces.length != 2) {
                retRecord.addHeaderMetadata(pieces[0], "");
                continue;
            }
            String thisKey = pieces[0].trim();
            String thisValue = pieces[1].trim();
            if (thisKey.equals("WARC-Type")) {
                retRecord.setWarcRecordType(thisValue);
                continue;
            }
            if (thisKey.equals("WARC-Date")) {
                retRecord.setWarcDate(thisValue);
                continue;
            }
            if (thisKey.equals("WARC-Record-ID")) {
                retRecord.setWarcUUID(thisValue);
                continue;
            }
            if (thisKey.equals("Content-Type")) {
                retRecord.setWarcContentType(thisValue);
                continue;
            }
            retRecord.addHeaderMetadata(thisKey, thisValue);
        }
        retRecord.setContent(recordContent);
        return retRecord;
    }

    public ClueWarcRecord() {
    }

    public ClueWarcRecord(ClueWarcRecord o) {
        this.warcHeader = new WarcHeader(o.warcHeader);
        this.warcContent = o.warcContent;
    }

    public int getTotalRecordLength() {
        int headerLength = this.warcHeader.toString().length();
        return headerLength + this.warcContent.length;
    }

    public void set(ClueWarcRecord o) {
        this.warcHeader = new WarcHeader(o.warcHeader);
        this.warcContent = o.warcContent;
    }

    public String getWarcFilePath() {
        return this.warcFilePath;
    }

    public void setWarcFilePath(String path) {
        this.warcFilePath = path;
    }

    public void setWarcRecordType(String recordType) {
        this.warcHeader.recordType = recordType;
    }

    public void setWarcContentType(String contentType) {
        this.warcHeader.contentType = contentType;
    }

    public void setWarcDate(String dateString) {
        this.warcHeader.dateString = dateString;
    }

    public void setWarcUUID(String UUID) {
        this.warcHeader.UUID = UUID;
    }

    public void addHeaderMetadata(String key, String value) {
        if (key.equals("WARC-Type")) {
            return;
        }
        if (key.equals("WARC-Date")) {
            return;
        }
        if (key.equals("WARC-Record-ID")) {
            return;
        }
        if (key.equals("Content-Type")) {
            return;
        }
        if (key.equals("Content-Length")) {
            return;
        }
        this.warcHeader.metadata.put(key, value);
    }

    public void clearHeaderMetadata() {
        this.warcHeader.metadata.clear();
    }

    public Set<Map.Entry<String, String>> getHeaderMetadata() {
        return this.warcHeader.metadata.entrySet();
    }

    public String getHeaderMetadataItem(String key) {
        return this.warcHeader.metadata.get(key);
    }

    public void setContent(byte[] content) {
        this.warcContent = content;
        this.warcHeader.contentLength = content.length;
    }

    public void setContent(String content) {
        this.setContent(content.getBytes());
    }

    public byte[] getByteContent() {
        return this.warcContent;
    }

    public String getContentUTF8() {
        String retString = null;
        try {
            retString = new String(this.warcContent, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            retString = new String(this.warcContent);
        }
        return retString;
    }

    public String getHeaderRecordType() {
        return this.warcHeader.recordType;
    }

    public String toString() {
        StringBuffer retBuffer = new StringBuffer();
        retBuffer.append(this.warcHeader.toString());
        retBuffer.append(NEWLINE);
        retBuffer.append(this.warcContent);
        return retBuffer.toString();
    }

    public String getHeaderString() {
        return this.warcHeader.toString();
    }

    public void write(DataOutput out) throws IOException {
        this.warcHeader.write(out);
        out.write(this.warcContent);
    }

    public void readFields(DataInput in) throws IOException {
        this.warcHeader.readFields(in);
        int contentLengthBytes = this.warcHeader.contentLength;
        this.warcContent = new byte[contentLengthBytes];
        in.readFully(this.warcContent);
    }

    @Override
    public String getDocid() {
        return this.getHeaderMetadataItem("WARC-TREC-ID");
    }

    @Override
    public String getContent() {
        String str = this.getContentUTF8();
        int i = str.indexOf("Content-Length:");
        int j = str.indexOf("\n", i);
        return str.substring(j + 1);
    }

    @Override
    public String getDisplayContentType() {
        return "text/html";
    }

    public class WarcHeader {
        public String contentType = "";
        public String UUID = "";
        public String dateString = "";
        public String recordType = "";
        public HashMap<String, String> metadata = new HashMap();
        public int contentLength = 0;

        public WarcHeader() {
        }

        public WarcHeader(WarcHeader o) {
            this.contentType = o.contentType;
            this.UUID = o.UUID;
            this.dateString = o.dateString;
            this.recordType = o.recordType;
            this.metadata.putAll(o.metadata);
            this.contentLength = o.contentLength;
        }

        public void write(DataOutput out) throws IOException {
            out.writeUTF(this.contentType);
            out.writeUTF(this.UUID);
            out.writeUTF(this.dateString);
            out.writeUTF(this.recordType);
            out.writeInt(this.metadata.size());
            for (Map.Entry<String, String> thisEntry : this.metadata.entrySet()) {
                out.writeUTF(thisEntry.getKey());
                out.writeUTF(thisEntry.getValue());
            }
            out.writeInt(this.contentLength);
        }

        public void readFields(DataInput in) throws IOException {
            this.contentType = in.readUTF();
            this.UUID = in.readUTF();
            this.dateString = in.readUTF();
            this.recordType = in.readUTF();
            this.metadata.clear();
            int numMetaItems = in.readInt();
            for (int i = 0; i < numMetaItems; ++i) {
                String thisKey = in.readUTF();
                String thisValue = in.readUTF();
                this.metadata.put(thisKey, thisValue);
            }
            this.contentLength = in.readInt();
        }

        public String toString() {
            StringBuffer retBuffer = new StringBuffer();
            retBuffer.append(WARC_VERSION);
            retBuffer.append(NEWLINE);
            retBuffer.append("WARC-Type: " + this.recordType + NEWLINE);
            retBuffer.append("WARC-Date: " + this.dateString + NEWLINE);
            retBuffer.append("WARC-Record-ID: " + this.UUID + NEWLINE);
            for (Map.Entry<String, String> thisEntry : this.metadata.entrySet()) {
                retBuffer.append(thisEntry.getKey());
                retBuffer.append(": ");
                retBuffer.append(thisEntry.getValue());
                retBuffer.append(NEWLINE);
            }
            retBuffer.append("Content-Type: " + this.contentType + NEWLINE);
            retBuffer.append("Content-Length: " + this.contentLength + NEWLINE);
            return retBuffer.toString();
        }
    }
}

