/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.line;

import edu.umd.cloud9.collection.line.TextDocument;
import edu.umd.cloud9.collection.line.TextDocumentInputFormat;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class DemoCountTextDocuments
extends Configured
implements Tool {
    private static final Logger sLogger = Logger.getLogger(DemoCountTextDocuments.class);

    private static int printUsage() {
        System.out.println("usage: [input]");
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        return -1;
    }

    public int run(String[] args) throws Exception {
        if (args.length != 1) {
            DemoCountTextDocuments.printUsage();
            return -1;
        }
        String inputPath = args[0];
        sLogger.info((Object)("input: " + inputPath));
        JobConf conf = new JobConf(DemoCountTextDocuments.class);
        conf.setJobName("DemoCountTextDocuments");
        conf.setNumReduceTasks(0);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{new Path(inputPath)});
        conf.setInputFormat(TextDocumentInputFormat.class);
        conf.setOutputFormat(NullOutputFormat.class);
        conf.setMapperClass(MyMapper.class);
        JobClient.runJob((JobConf)conf);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new DemoCountTextDocuments(), (String[])args);
        System.exit(res);
    }

    private static class MyMapper
    extends MapReduceBase
    implements Mapper<LongWritable, TextDocument, NullWritable, NullWritable> {
        private MyMapper() {
        }

        public void configure(JobConf job) {
        }

        public void map(LongWritable key, TextDocument doc, OutputCollector<NullWritable, NullWritable> output, Reporter reporter) throws IOException {
            reporter.incrCounter((Enum)Count.DOCS, 1L);
        }
    }

    private static enum Count {
        DOCS;

    }
}

