/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.line;

import edu.umd.cloud9.collection.line.TextDocument;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class TextDocumentTest {
    @org.junit.Test
    public void testCreate() {
        TextDocument doc = new TextDocument();
        TextDocument.readDocument(doc, "docid1\tHere are the contents of the document");
        Assert.assertEquals((Object)"docid1", (Object)doc.getDocid());
        Assert.assertEquals((Object)"Here are the contents of the document", (Object)doc.getContent());
    }

    @org.junit.Test
    public void testSerialization() throws IOException {
        TextDocument doc = new TextDocument();
        TextDocument.readDocument(doc, "docid1\tHere are the contents of the document");
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        doc.write(dataOut);
        TextDocument doc1 = new TextDocument();
        doc1.readFields(new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((Object)"docid1", (Object)doc1.getDocid());
        Assert.assertEquals((Object)"Here are the contents of the document", (Object)doc1.getContent());
    }

    public static Test suite() {
        return new JUnit4TestAdapter(TextDocumentTest.class);
    }
}

