/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.medline;

import edu.umd.cloud9.collection.DocnoMapping;
import edu.umd.cloud9.collection.medline.MedlineCitation;
import edu.umd.cloud9.collection.medline.MedlineCitationInputFormat;
import edu.umd.cloud9.collection.medline.MedlineDocnoMapping;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class CountMedlineCitations
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(CountMedlineCitations.class);
    public static final String COLLECTION_OPTION = "collection";
    public static final String OUTPUT_OPTION = "output";
    public static final String MAPPING_OPTION = "docnoMapping";

    public int run(String[] args) throws Exception {
        CommandLine cmdline;
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"(required) collection path");
        options.addOption(OptionBuilder.create((String)COLLECTION_OPTION));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"(required) output path");
        options.addOption(OptionBuilder.create((String)OUTPUT_OPTION));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"(required) DocnoMapping data");
        options.addOption(OptionBuilder.create((String)MAPPING_OPTION));
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            return -1;
        }
        if (!(cmdline.hasOption(COLLECTION_OPTION) && cmdline.hasOption(OUTPUT_OPTION) && cmdline.hasOption(MAPPING_OPTION))) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(((Object)((Object)this)).getClass().getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        String inputPath = cmdline.getOptionValue(COLLECTION_OPTION);
        String outputPath = cmdline.getOptionValue(OUTPUT_OPTION);
        String mappingFile = cmdline.getOptionValue(MAPPING_OPTION);
        LOG.info((Object)("Tool: " + CountMedlineCitations.class.getSimpleName()));
        LOG.info((Object)(" - input: " + inputPath));
        LOG.info((Object)(" - output dir: " + outputPath));
        LOG.info((Object)(" - docno mapping file: " + mappingFile));
        Job job = new Job(this.getConf(), CountMedlineCitations.class.getSimpleName() + ":" + inputPath);
        job.setJarByClass(CountMedlineCitations.class);
        job.setNumReduceTasks(0);
        job.getConfiguration().set("DocnoMappingClass", MedlineDocnoMapping.class.getCanonicalName());
        DistributedCache.addCacheFile((URI)new URI(mappingFile), (Configuration)job.getConfiguration());
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(inputPath)});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputPath));
        FileOutputFormat.setCompressOutput((Job)job, (boolean)false);
        job.setInputFormatClass(MedlineCitationInputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(IntWritable.class);
        job.setMapperClass(MyMapper.class);
        FileSystem.get((Configuration)job.getConfiguration()).delete(new Path(outputPath), true);
        job.waitForCompletion(true);
        Counters counters = job.getCounters();
        int numDocs = (int)counters.findCounter((Enum)Count.DOCS).getValue();
        LOG.info((Object)("Read " + numDocs + " docs."));
        return numDocs;
    }

    public static void main(String[] args) throws Exception {
        LOG.info((Object)("Running " + CountMedlineCitations.class.getCanonicalName() + " with args " + Arrays.toString(args)));
        ToolRunner.run((Tool)new CountMedlineCitations(), (String[])args);
    }

    private static class MyMapper
    extends Mapper<LongWritable, MedlineCitation, Text, IntWritable> {
        private static final Text docid = new Text();
        private static final IntWritable val = new IntWritable(1);
        private DocnoMapping docMapping;

        private MyMapper() {
        }

        public void setup(Mapper.Context context) {
            try {
                Configuration conf = context.getConfiguration();
                Path[] localFiles = DistributedCache.getLocalCacheFiles((Configuration)conf);
                this.docMapping = (DocnoMapping)Class.forName(conf.get("DocnoMappingClass")).newInstance();
                this.docMapping.loadMapping(localFiles[0], (FileSystem)FileSystem.getLocal((Configuration)conf));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Error initializing DocnoMapping!");
            }
        }

        public void map(LongWritable key, MedlineCitation doc, Mapper.Context context) throws IOException, InterruptedException {
            context.getCounter((Enum)Count.DOCS).increment(1L);
            docid.set(doc.getDocid());
            int docno = this.docMapping.getDocno(doc.getDocid());
            if (docno <= 0) {
                throw new RuntimeException("Error, unable to find docno for docid " + docid);
            }
            val.set(docno);
            context.write((Object)docid, (Object)val);
        }
    }

    private static enum Count {
        DOCS;

    }
}

