/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.medline;

import edu.umd.cloud9.collection.IndexableFileInputFormatOld;
import edu.umd.cloud9.collection.XMLInputFormatOld;
import edu.umd.cloud9.collection.medline.MedlineCitation;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class MedlineCitationInputFormatOld
extends IndexableFileInputFormatOld<LongWritable, MedlineCitation>
implements JobConfigurable {
    private CompressionCodecFactory compressionCodecs = null;

    public void configure(JobConf conf) {
        this.compressionCodecs = new CompressionCodecFactory((Configuration)conf);
    }

    protected boolean isSplitable(FileSystem fs, Path file) {
        return this.compressionCodecs.getCodec(file) == null;
    }

    public RecordReader<LongWritable, MedlineCitation> getRecordReader(InputSplit inputSplit, JobConf conf, Reporter reporter) throws IOException {
        return new MedlineCitationRecordReader((FileSplit)inputSplit, conf);
    }

    public static class MedlineCitationRecordReader
    implements RecordReader<LongWritable, MedlineCitation> {
        private XMLInputFormatOld.XMLRecordReader reader;
        private Text text = new Text();
        private LongWritable pos = new LongWritable();

        public MedlineCitationRecordReader(FileSplit split, JobConf conf) throws IOException {
            conf.set("xmlinput.start", "<MedlineCitation");
            conf.set("xmlinput.end", "</MedlineCitation>");
            this.reader = new XMLInputFormatOld.XMLRecordReader(split, conf);
        }

        public boolean next(LongWritable key, MedlineCitation value) throws IOException {
            if (!this.reader.next(this.pos, this.text)) {
                return false;
            }
            key.set(this.pos.get());
            MedlineCitation.readCitation(value, this.text.toString());
            return true;
        }

        public LongWritable createKey() {
            return new LongWritable();
        }

        public MedlineCitation createValue() {
            return new MedlineCitation();
        }

        public long getPos() throws IOException {
            return this.reader.getPos();
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public float getProgress() throws IOException {
            return (float)(this.reader.getPos() - this.reader.getStart()) / (float)(this.reader.getEnd() - this.reader.getStart());
        }
    }
}

