/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.trec;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cloud9.collection.DocnoMapping;
import edu.umd.cloud9.collection.trec.TrecDocnoMappingBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.LineReader;
import org.apache.log4j.Logger;

public class TrecDocnoMapping
implements DocnoMapping {
    private static final Logger LOG = Logger.getLogger(TrecDocnoMapping.class);
    private String[] docids;

    @Override
    public int getDocno(String docid) {
        Preconditions.checkNotNull((Object)docid);
        return Arrays.binarySearch(this.docids, docid);
    }

    @Override
    public String getDocid(int docno) {
        return this.docids[docno];
    }

    @Override
    public void loadMapping(Path p, FileSystem fs) throws IOException {
        Preconditions.checkNotNull((Object)p);
        Preconditions.checkNotNull((Object)fs);
        this.docids = TrecDocnoMapping.readMappingData(p, fs);
    }

    public static void writeMappingData(Path input, Path output, FileSystem fs) throws IOException {
        Preconditions.checkNotNull((Object)input);
        Preconditions.checkNotNull((Object)output);
        Preconditions.checkNotNull((Object)fs);
        LOG.info((Object)("Writing docno data to " + output));
        LineReader reader = new LineReader((InputStream)fs.open(input));
        ArrayList list = Lists.newArrayList();
        LOG.info((Object)("Reading " + input));
        int cnt = 0;
        Text line = new Text();
        while (reader.readLine(line) > 0) {
            String[] arr = line.toString().split("\\t");
            list.add(arr[0]);
            if (++cnt % 100000 != 0) continue;
            LOG.info((Object)(cnt + " docs"));
        }
        reader.close();
        LOG.info((Object)(cnt + " docs total. Done!"));
        cnt = 0;
        LOG.info((Object)("Writing " + output));
        FSDataOutputStream out = fs.create(output, true);
        out.writeInt(list.size());
        for (int i = 0; i < list.size(); ++i) {
            out.writeUTF((String)list.get(i));
            if (++cnt % 100000 != 0) continue;
            LOG.info((Object)(cnt + " docs"));
        }
        out.close();
        LOG.info((Object)(cnt + " docs total. Done!"));
    }

    public static String[] readMappingData(Path p, FileSystem fs) throws IOException {
        Preconditions.checkNotNull((Object)p);
        Preconditions.checkNotNull((Object)fs);
        FSDataInputStream in = fs.open(p);
        int sz = in.readInt() + 1;
        String[] arr = new String[sz];
        for (int i = 1; i < sz; ++i) {
            arr[i] = in.readUTF();
        }
        in.close();
        arr[0] = "";
        return arr;
    }

    @Override
    public DocnoMapping.Builder getBuilder() {
        return new TrecDocnoMappingBuilder();
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("usage: (list|getDocno|getDocid) [mapping-file] [docid/docno]");
            System.exit(-1);
        }
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        System.out.println("loading mapping file " + args[1]);
        TrecDocnoMapping mapping = new TrecDocnoMapping();
        mapping.loadMapping(new Path(args[1]), fs);
        if (args[0].equals("list")) {
            for (int i = 1; i < mapping.docids.length; ++i) {
                System.out.println(i + "\t" + mapping.docids[i]);
            }
        } else if (args[0].equals("getDocno")) {
            System.out.println("looking up docno for \"" + args[2] + "\"");
            int idx = mapping.getDocno(args[2]);
            if (idx > 0) {
                System.out.println(mapping.getDocno(args[2]));
            } else {
                System.err.print("Invalid docid!");
            }
        } else if (args[0].equals("getDocid")) {
            try {
                System.out.println("looking up docid for " + args[2]);
                System.out.println(mapping.getDocid(Integer.parseInt(args[2])));
            }
            catch (Exception e) {
                System.err.print("Invalid docno!");
            }
        } else {
            System.out.println("Invalid command!");
            System.out.println("usage: (list|getDocno|getDocid) [mappings-file] [docid/docno]");
        }
    }
}

