/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.trec;

import edu.umd.cloud9.collection.DocnoMapping;
import edu.umd.cloud9.collection.trec.TrecDocnoMapping;
import edu.umd.cloud9.collection.trec.TrecDocument;
import edu.umd.cloud9.collection.trec.TrecDocumentInputFormat;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class TrecDocnoMappingBuilder
extends Configured
implements Tool,
DocnoMapping.Builder {
    private static final Logger LOG = Logger.getLogger(TrecDocnoMappingBuilder.class);
    private static final Random RANDOM = new Random();

    @Override
    public int build(Path src, Path dest, Configuration conf) throws IOException {
        super.setConf(conf);
        return this.run(new String[]{"-collection=" + src.toString(), "-docnoMapping=" + dest.toString()});
    }

    public int run(String[] args) throws IOException {
        DocnoMapping.DefaultBuilderOptions options = DocnoMapping.BuilderUtils.parseDefaultOptions(args);
        if (options == null) {
            return -1;
        }
        String tmpDir = "tmp-" + TrecDocnoMappingBuilder.class.getSimpleName() + "-" + RANDOM.nextInt(10000);
        LOG.info((Object)("Tool name: " + TrecDocnoMappingBuilder.class.getCanonicalName()));
        LOG.info((Object)(" - input path: " + options.collection));
        LOG.info((Object)(" - output file: " + options.docnoMapping));
        Job job = new Job(this.getConf(), TrecDocnoMappingBuilder.class.getSimpleName() + ":" + options.collection);
        FileSystem fs = FileSystem.get((Configuration)job.getConfiguration());
        job.setJarByClass(TrecDocnoMappingBuilder.class);
        job.setNumReduceTasks(1);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(options.collection)});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(tmpDir));
        FileOutputFormat.setCompressOutput((Job)job, (boolean)false);
        job.setInputFormatClass(TrecDocumentInputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(IntWritable.class);
        job.setOutputFormatClass(TextOutputFormat.class);
        job.setMapperClass(MyMapper.class);
        job.setReducerClass(MyReducer.class);
        fs.delete(new Path(tmpDir), true);
        try {
            job.waitForCompletion(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String input = tmpDir + (tmpDir.endsWith("/") ? "" : "/") + "/part-r-00000";
        TrecDocnoMapping.writeMappingData(new Path(input), new Path(options.docnoMapping), FileSystem.get((Configuration)this.getConf()));
        fs.delete(new Path(tmpDir), true);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        LOG.info((Object)("Running " + TrecDocnoMappingBuilder.class.getCanonicalName() + " with args " + Arrays.toString(args)));
        ToolRunner.run((Configuration)new Configuration(), (Tool)new TrecDocnoMappingBuilder(), (String[])args);
    }

    private static class MyReducer
    extends Reducer<Text, IntWritable, Text, IntWritable> {
        private static final IntWritable cnt = new IntWritable(1);

        private MyReducer() {
        }

        public void reduce(Text key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            context.write((Object)key, (Object)cnt);
            cnt.set(cnt.get() + 1);
        }
    }

    private static class MyMapper
    extends Mapper<LongWritable, TrecDocument, Text, IntWritable> {
        private static final Text docid = new Text();
        private static final IntWritable one = new IntWritable(1);

        private MyMapper() {
        }

        public void map(LongWritable key, TrecDocument doc, Mapper.Context context) throws IOException, InterruptedException {
            context.getCounter((Enum)Count.DOCS).increment(1L);
            docid.set(doc.getDocid());
            context.write((Object)docid, (Object)one);
        }
    }

    private static enum Count {
        DOCS;

    }
}

