/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.trec;

import com.google.common.base.Preconditions;
import edu.umd.cloud9.collection.WebDocument;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableUtils;

public class TrecDocument
extends WebDocument {
    public static final String XML_START_TAG = "<DOC>";
    public static final String XML_END_TAG = "</DOC>";
    private String doc;
    private String docid;

    public void write(DataOutput out) throws IOException {
        byte[] bytes = this.doc.getBytes();
        WritableUtils.writeVInt((DataOutput)out, (int)bytes.length);
        out.write(bytes, 0, bytes.length);
    }

    public void readFields(DataInput in) throws IOException {
        int length = WritableUtils.readVInt((DataInput)in);
        byte[] bytes = new byte[length];
        in.readFully(bytes, 0, length);
        TrecDocument.readDocument(this, new String(bytes));
    }

    @Override
    public String getDocid() {
        if (this.docid == null) {
            int start = this.doc.indexOf("<DOCNO>");
            if (start == -1) {
                this.docid = "";
            } else {
                int end = this.doc.indexOf("</DOCNO>", start);
                this.docid = this.doc.substring(start + 7, end).trim();
            }
        }
        return this.docid;
    }

    @Override
    public String getContent() {
        return this.doc;
    }

    public static void readDocument(TrecDocument doc, String s) {
        Preconditions.checkNotNull((Object)s);
        Preconditions.checkNotNull((Object)doc);
        doc.doc = s;
        doc.docid = null;
    }

    @Override
    public String getURL() {
        return null;
    }
}

