/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.trec;

import edu.umd.cloud9.collection.IndexableFileInputFormat;
import edu.umd.cloud9.collection.WebDocument;
import edu.umd.cloud9.collection.XMLInputFormat;
import edu.umd.cloud9.collection.trec.TrecDocument;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class TrecDocumentInputFormat
extends IndexableFileInputFormat<LongWritable, WebDocument> {
    public RecordReader<LongWritable, WebDocument> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new TrecDocumentRecordReader();
    }

    public static class TrecDocumentRecordReader
    extends RecordReader<LongWritable, WebDocument> {
        private final XMLInputFormat.XMLRecordReader reader = new XMLInputFormat.XMLRecordReader();
        private final TrecDocument doc = new TrecDocument();

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            conf.set("xmlinput.start", "<DOC>");
            conf.set("xmlinput.end", "</DOC>");
            this.reader.initialize(split, context);
        }

        public LongWritable getCurrentKey() throws IOException, InterruptedException {
            return this.reader.getCurrentKey();
        }

        public WebDocument getCurrentValue() throws IOException, InterruptedException {
            TrecDocument.readDocument(this.doc, this.reader.getCurrentValue().toString());
            return this.doc;
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            return this.reader.nextKeyValue();
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public float getProgress() throws IOException, InterruptedException {
            return this.reader.getProgress();
        }
    }
}

