/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.trec;

import edu.umd.cloud9.collection.IndexableFileInputFormatOld;
import edu.umd.cloud9.collection.XMLInputFormatOld;
import edu.umd.cloud9.collection.trec.TrecDocument;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class TrecDocumentInputFormatOld
extends IndexableFileInputFormatOld<LongWritable, TrecDocument> {
    public RecordReader<LongWritable, TrecDocument> getRecordReader(InputSplit inputSplit, JobConf conf, Reporter reporter) throws IOException {
        return new TrecDocumentRecordReader((FileSplit)inputSplit, conf);
    }

    public static class TrecDocumentRecordReader
    implements RecordReader<LongWritable, TrecDocument> {
        private XMLInputFormatOld.XMLRecordReader reader;
        private Text text = new Text();
        private LongWritable pos = new LongWritable();

        public TrecDocumentRecordReader(FileSplit split, JobConf conf) throws IOException {
            conf.set("xmlinput.start", "<DOC>");
            conf.set("xmlinput.end", "</DOC>");
            this.reader = new XMLInputFormatOld.XMLRecordReader(split, conf);
        }

        public boolean next(LongWritable key, TrecDocument value) throws IOException {
            if (!this.reader.next(this.pos, this.text)) {
                return false;
            }
            key.set(this.pos.get());
            TrecDocument.readDocument(value, this.text.toString());
            return true;
        }

        public LongWritable createKey() {
            return new LongWritable();
        }

        public TrecDocument createValue() {
            return new TrecDocument();
        }

        public long getPos() throws IOException {
            return this.reader.getPos();
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public float getProgress() throws IOException {
            return (float)(this.reader.getPos() - this.reader.getStart()) / (float)(this.reader.getEnd() - this.reader.getStart());
        }
    }
}

