/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.trec;

import com.google.common.base.Preconditions;
import edu.umd.cloud9.collection.DocumentForwardIndex;
import edu.umd.cloud9.collection.trec.TrecDocnoMapping;
import edu.umd.cloud9.collection.trec.TrecDocument;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class TrecForwardIndex
implements DocumentForwardIndex<TrecDocument> {
    private static final Logger LOG = Logger.getLogger(TrecForwardIndex.class);
    private long[] offsets;
    private int[] lengths;
    private FSDataInputStream input;
    private TrecDocnoMapping docnoMapping = new TrecDocnoMapping();
    private String path;

    @Override
    public int getDocno(String docid) {
        Preconditions.checkNotNull((Object)docid);
        return this.docnoMapping.getDocno(docid);
    }

    @Override
    public String getDocid(int docno) {
        return this.docnoMapping.getDocid(docno);
    }

    @Override
    public int getLastDocno() {
        return this.offsets.length - 1;
    }

    @Override
    public int getFirstDocno() {
        return 1;
    }

    @Override
    public String getCollectionPath() {
        return this.path;
    }

    @Override
    public TrecDocument getDocument(String docid) {
        return this.getDocument(this.docnoMapping.getDocno(docid));
    }

    @Override
    public TrecDocument getDocument(int docno) {
        TrecDocument doc = new TrecDocument();
        try {
            LOG.info((Object)String.format("docno %d: byte offset %d, length %d", docno, this.offsets[docno], this.lengths[docno]));
            this.input.seek(this.offsets[docno]);
            byte[] arr = new byte[this.lengths[docno]];
            this.input.read(arr);
            TrecDocument.readDocument(doc, new String(arr));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return doc;
    }

    @Override
    public void loadIndex(Path index, Path mapping, FileSystem fs) throws IOException {
        FSDataInputStream in = fs.open(index);
        in.readUTF();
        this.path = in.readUTF();
        int sz = in.readInt() + 1;
        this.offsets = new long[sz];
        this.lengths = new int[sz];
        for (int i = 1; i < sz; ++i) {
            this.offsets[i] = in.readLong();
            this.lengths[i] = in.readInt();
        }
        in.close();
        this.input = fs.open(new Path(this.path));
        this.docnoMapping.loadMapping(mapping, fs);
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 4) {
            System.out.println("usage: [findex] [mapping-file] [getDocno|getDocid] [docid/docno]");
            System.exit(-1);
        }
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        System.out.println("forward index: " + args[0]);
        System.out.println("mapping file: " + args[1]);
        TrecForwardIndex findex = new TrecForwardIndex();
        findex.loadIndex(new Path(args[0]), new Path(args[1]), fs);
        if (args[2].equals("getDocno")) {
            System.out.println("looking up docno " + args[3]);
            System.out.println(findex.getDocument(Integer.parseInt(args[3])).getDisplayContent());
        } else if (args[2].equals("getDocid")) {
            System.out.println("looking up docid " + args[3]);
            System.out.println(findex.getDocument(args[3]).getDisplayContent());
        } else {
            System.out.println("Invalid command!");
            System.out.println("usage: [findex] [mapping-file] [getDocno|getDocid] [docid/docno]");
        }
    }
}

