/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.trec;

import edu.umd.cloud9.collection.DocnoMapping;
import edu.umd.cloud9.collection.trec.TrecDocnoMapping;
import edu.umd.cloud9.collection.trec.TrecDocument;
import edu.umd.cloud9.collection.trec.TrecDocumentInputFormat;
import edu.umd.cloud9.collection.trec.TrecForwardIndex;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.LineReader;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class TrecForwardIndexBuilder
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(TrecForwardIndexBuilder.class);
    private static final Random random = new Random();
    private static final String DOCNO_MAPPING_FILE_PROPERTY = "DocnoMappingFile";
    public static final String COLLECTION_OPTION = "collection";
    public static final String INDEX_OPTION = "index";
    public static final String MAPPING_OPTION = "docnoMapping";

    public int run(String[] args) throws Exception {
        CommandLine cmdline;
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"(required) collection path");
        options.addOption(OptionBuilder.create((String)COLLECTION_OPTION));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"(required) output index path");
        options.addOption(OptionBuilder.create((String)INDEX_OPTION));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"(required) DocnoMapping data");
        options.addOption(OptionBuilder.create((String)MAPPING_OPTION));
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            return -1;
        }
        if (!(cmdline.hasOption(COLLECTION_OPTION) && cmdline.hasOption(INDEX_OPTION) && cmdline.hasOption(MAPPING_OPTION))) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(((Object)((Object)this)).getClass().getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        String collectionPath = cmdline.getOptionValue(COLLECTION_OPTION);
        String indexFile = cmdline.getOptionValue(INDEX_OPTION);
        String mappingFile = cmdline.getOptionValue(MAPPING_OPTION);
        String tmpDir = "tmp-" + TrecForwardIndexBuilder.class.getSimpleName() + "-" + random.nextInt(10000);
        Job job = new Job(this.getConf(), TrecForwardIndexBuilder.class.getSimpleName() + ":" + collectionPath);
        job.setJarByClass(TrecForwardIndexBuilder.class);
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        LOG.info((Object)("Tool name: " + TrecForwardIndexBuilder.class.getSimpleName()));
        LOG.info((Object)(" - collection path: " + collectionPath));
        LOG.info((Object)(" - index file: " + indexFile));
        LOG.info((Object)(" - DocnoMapping file: " + mappingFile));
        LOG.info((Object)(" - temp output directory: " + tmpDir));
        job.setNumReduceTasks(1);
        if (job.getConfiguration().get("mapred.job.tracker").equals("local")) {
            job.getConfiguration().set(DOCNO_MAPPING_FILE_PROPERTY, mappingFile);
        } else {
            DistributedCache.addCacheFile((URI)new URI(mappingFile), (Configuration)job.getConfiguration());
        }
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(collectionPath)});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(tmpDir));
        FileOutputFormat.setCompressOutput((Job)job, (boolean)false);
        job.setInputFormatClass(TrecDocumentInputFormat.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(Text.class);
        job.setMapperClass(MyMapper.class);
        FileSystem.get((Configuration)this.getConf()).delete(new Path(tmpDir), true);
        job.waitForCompletion(true);
        Counters counters = job.getCounters();
        int numDocs = (int)counters.findCounter((Enum)Count.DOCS).getValue();
        String inputFile = tmpDir + "/" + "part-r-00000";
        LOG.info((Object)("Writing " + numDocs + " doc offseta to " + indexFile));
        LineReader reader = new LineReader((InputStream)fs.open(new Path(inputFile)));
        FSDataOutputStream writer = fs.create(new Path(indexFile), true);
        writer.writeUTF(TrecForwardIndex.class.getCanonicalName());
        writer.writeUTF(collectionPath);
        writer.writeInt(numDocs);
        int cnt = 0;
        Text line = new Text();
        while (reader.readLine(line) > 0) {
            String[] arr = line.toString().split("\\t");
            long offset = Long.parseLong(arr[1]);
            int len = Integer.parseInt(arr[2]);
            writer.writeLong(offset);
            writer.writeInt(len);
            if (++cnt % 100000 != 0) continue;
            LOG.info((Object)(cnt + " docs"));
        }
        reader.close();
        writer.close();
        LOG.info((Object)(cnt + " docs total. Done!"));
        if (numDocs != cnt) {
            throw new RuntimeException("Unexpected number of documents in building forward index!");
        }
        fs.delete(new Path(tmpDir), true);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        LOG.info((Object)("Running " + TrecForwardIndexBuilder.class.getCanonicalName() + " with args " + Arrays.toString(args)));
        ToolRunner.run((Configuration)new Configuration(), (Tool)new TrecForwardIndexBuilder(), (String[])args);
    }

    private static class MyMapper
    extends Mapper<LongWritable, TrecDocument, IntWritable, Text> {
        private static final IntWritable docno = new IntWritable(1);
        private static final Text text = new Text();
        private DocnoMapping docMapping;

        private MyMapper() {
        }

        public void setup(Mapper.Context context) {
            try {
                Configuration conf = context.getConfiguration();
                this.docMapping = new TrecDocnoMapping();
                if (conf.get("mapred.job.tracker").equals("local")) {
                    FileSystem fs = FileSystem.get((Configuration)conf);
                    String mappingFile = conf.get(TrecForwardIndexBuilder.DOCNO_MAPPING_FILE_PROPERTY);
                    this.docMapping.loadMapping(new Path(mappingFile), fs);
                } else {
                    Path[] localFiles = DistributedCache.getLocalCacheFiles((Configuration)conf);
                    this.docMapping.loadMapping(localFiles[0], (FileSystem)FileSystem.getLocal((Configuration)conf));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Error initializing DocnoMapping!");
            }
        }

        public void map(LongWritable key, TrecDocument doc, Mapper.Context context) throws IOException, InterruptedException {
            context.getCounter((Enum)Count.DOCS).increment(1L);
            int len = doc.getContent().getBytes().length;
            docno.set(this.docMapping.getDocno(doc.getDocid()));
            text.set(key + "\t" + len);
            context.write((Object)docno, (Object)text);
        }
    }

    private static enum Count {
        DOCS;

    }
}

