/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.trecweb;

import edu.umd.cloud9.collection.IndexableFileInputFormatOld;
import edu.umd.cloud9.collection.XMLInputFormatOld;
import edu.umd.cloud9.collection.trecweb.TrecWebDocument;
import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class TrecWebDocumentInputFormatOld
extends IndexableFileInputFormatOld<LongWritable, TrecWebDocument> {
    protected boolean isSplitable(FileSystem fs, Path filename) {
        return false;
    }

    public RecordReader<LongWritable, TrecWebDocument> getRecordReader(InputSplit inputSplit, JobConf conf, Reporter reporter) throws IOException {
        return new TrecWebRecordReader((FileSplit)inputSplit, conf);
    }

    public static class TrecWebRecordReader
    implements RecordReader<LongWritable, TrecWebDocument> {
        private final XMLInputFormatOld.XMLRecordReader reader;
        private final Text text = new Text();
        private final LongWritable inputKey = new LongWritable();

        public TrecWebRecordReader(FileSplit split, JobConf conf) throws IOException {
            conf.set("xmlinput.start", "<DOC>");
            conf.set("xmlinput.end", "</DOC>");
            this.reader = new XMLInputFormatOld.XMLRecordReader(split, conf);
        }

        public boolean next(LongWritable key, TrecWebDocument value) throws IOException {
            if (!this.reader.next(this.inputKey, this.text)) {
                return false;
            }
            key.set(this.inputKey.get());
            TrecWebDocument.readDocument(value, this.text.toString());
            return true;
        }

        public LongWritable createKey() {
            return new LongWritable();
        }

        public TrecWebDocument createValue() {
            return new TrecWebDocument();
        }

        public long getPos() throws IOException {
            return this.reader.getPos();
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public float getProgress() throws IOException {
            return (float)(this.reader.getPos() - this.reader.getStart()) / (float)(this.reader.getEnd() - this.reader.getStart());
        }
    }
}

