/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.wikipedia;

import edu.umd.cloud9.collection.wikipedia.WikipediaDocnoMapping;
import edu.umd.cloud9.collection.wikipedia.WikipediaPage;
import edu.umd.cloud9.collection.wikipedia.WikipediaPageInputFormat;
import edu.umd.cloud9.collection.wikipedia.language.WikipediaPageFactory;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class RepackWikipedia
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(RepackWikipedia.class);
    private static final String DOCNO_MAPPING_FIELD = "DocnoMappingDataFile";
    private static final String INPUT_OPTION = "input";
    private static final String OUTPUT_OPTION = "output";
    private static final String MAPPING_FILE_OPTION = "mapping_file";
    private static final String COMPRESSION_TYPE_OPTION = "compression_type";
    private static final String LANGUAGE_OPTION = "wiki_language";

    public int run(String[] args) throws Exception {
        CommandLine cmdline;
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"XML dump file");
        options.addOption(OptionBuilder.create((String)INPUT_OPTION));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"output location");
        options.addOption(OptionBuilder.create((String)OUTPUT_OPTION));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"mapping file");
        options.addOption(OptionBuilder.create((String)MAPPING_FILE_OPTION));
        OptionBuilder.withArgName((String)"block|record|none");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"compression type");
        options.addOption(OptionBuilder.create((String)COMPRESSION_TYPE_OPTION));
        OptionBuilder.withArgName((String)"en|sv|de");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"two-letter language code");
        options.addOption(OptionBuilder.create((String)LANGUAGE_OPTION));
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            return -1;
        }
        if (!(cmdline.hasOption(INPUT_OPTION) && cmdline.hasOption(OUTPUT_OPTION) && cmdline.hasOption(MAPPING_FILE_OPTION) && cmdline.hasOption(COMPRESSION_TYPE_OPTION))) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(((Object)((Object)this)).getClass().getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        String inputPath = cmdline.getOptionValue(INPUT_OPTION);
        String outputPath = cmdline.getOptionValue(OUTPUT_OPTION);
        String mappingFile = cmdline.getOptionValue(MAPPING_FILE_OPTION);
        String compressionType = cmdline.getOptionValue(COMPRESSION_TYPE_OPTION);
        if (!("block".equals(compressionType) || "record".equals(compressionType) || "none".equals(compressionType))) {
            System.err.println("Error: \"" + compressionType + "\" unknown compression type!");
            return -1;
        }
        String language = null;
        if (cmdline.hasOption(LANGUAGE_OPTION) && (language = cmdline.getOptionValue(LANGUAGE_OPTION)).length() != 2) {
            System.err.println("Error: \"" + language + "\" unknown language!");
            return -1;
        }
        int blocksize = 1000000;
        Job job = Job.getInstance((Configuration)this.getConf());
        job.setJarByClass(RepackWikipedia.class);
        job.setJobName(String.format("RepackWikipedia[%s: %s, %s: %s, %s: %s, %s: %s]", INPUT_OPTION, inputPath, OUTPUT_OPTION, outputPath, COMPRESSION_TYPE_OPTION, compressionType, LANGUAGE_OPTION, language));
        job.getConfiguration().set(DOCNO_MAPPING_FIELD, mappingFile);
        LOG.info((Object)("Tool name: " + ((Object)((Object)this)).getClass().getName()));
        LOG.info((Object)(" - XML dump file: " + inputPath));
        LOG.info((Object)(" - output path: " + outputPath));
        LOG.info((Object)(" - docno mapping data file: " + mappingFile));
        LOG.info((Object)(" - compression type: " + compressionType));
        LOG.info((Object)(" - language: " + language));
        if ("block".equals(compressionType)) {
            LOG.info((Object)(" - block size: " + blocksize));
        }
        job.setNumReduceTasks(0);
        SequenceFileInputFormat.addInputPath((Job)job, (Path)new Path(inputPath));
        SequenceFileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputPath));
        if ("none".equals(compressionType)) {
            SequenceFileOutputFormat.setCompressOutput((Job)job, (boolean)false);
        } else {
            SequenceFileOutputFormat.setCompressOutput((Job)job, (boolean)true);
            if ("record".equals(compressionType)) {
                SequenceFileOutputFormat.setOutputCompressionType((Job)job, (SequenceFile.CompressionType)SequenceFile.CompressionType.RECORD);
            } else {
                SequenceFileOutputFormat.setOutputCompressionType((Job)job, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
                job.getConfiguration().setInt("io.seqfile.compress.blocksize", blocksize);
            }
        }
        if (language != null) {
            job.getConfiguration().set("wiki.language", language);
        }
        job.setInputFormatClass(WikipediaPageInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(WikipediaPageFactory.getWikipediaPageClass(language));
        job.setMapperClass(MyMapper.class);
        FileSystem.get((Configuration)this.getConf()).delete(new Path(outputPath), true);
        job.waitForCompletion(true);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new RepackWikipedia(), (String[])args);
    }

    private static class MyMapper
    extends Mapper<LongWritable, WikipediaPage, IntWritable, WikipediaPage> {
        private static final IntWritable docno = new IntWritable();
        private static final WikipediaDocnoMapping docnoMapping = new WikipediaDocnoMapping();

        private MyMapper() {
        }

        public void setup(Mapper.Context context) {
            try {
                Path p = new Path(context.getConfiguration().get(RepackWikipedia.DOCNO_MAPPING_FIELD));
                LOG.info((Object)("Loading docno mapping: " + p));
                FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
                if (!fs.exists(p)) {
                    throw new RuntimeException(p + " does not exist!");
                }
                docnoMapping.loadMapping(p, fs);
            }
            catch (Exception e) {
                throw new RuntimeException("Error loading docno mapping data file!");
            }
        }

        public void map(LongWritable key, WikipediaPage doc, Mapper.Context context) throws IOException, InterruptedException {
            int n;
            context.getCounter((Enum)Records.TOTAL).increment(1L);
            String id = doc.getDocid();
            if (id != null && (n = docnoMapping.getDocno(id)) >= 0) {
                docno.set(n);
                context.write((Object)docno, (Object)doc);
            }
        }
    }

    private static enum Records {
        TOTAL;

    }
}

