/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.wikipedia;

import edu.umd.cloud9.collection.DocnoMapping;
import edu.umd.cloud9.collection.wikipedia.WikipediaDocnoMappingBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.LineReader;
import org.apache.log4j.Logger;

public class WikipediaDocnoMapping
implements DocnoMapping {
    private static final Logger LOG = Logger.getLogger(WikipediaDocnoMapping.class);
    private int[] docids;

    @Override
    public int getDocno(String docid) {
        return Arrays.binarySearch(this.docids, Integer.parseInt(docid));
    }

    @Override
    public String getDocid(int docno) {
        return String.valueOf(this.docids[docno]);
    }

    @Override
    public void loadMapping(Path p, FileSystem fs) throws IOException {
        this.docids = WikipediaDocnoMapping.readDocnoMappingData(p, fs);
    }

    public static void writeDocnoMappingData(FileSystem fs, String inputFile, int n, String outputFile) throws IOException {
        LOG.info((Object)("Writing " + n + " docids to " + outputFile));
        LineReader reader = new LineReader((InputStream)fs.open(new Path(inputFile)));
        int cnt = 0;
        Text line = new Text();
        FSDataOutputStream out = fs.create(new Path(outputFile), true);
        out.writeInt(n);
        for (int i = 0; i < n; ++i) {
            reader.readLine(line);
            String[] arr = line.toString().split("\\t");
            out.writeInt(Integer.parseInt(arr[0]));
            if (++cnt % 100000 != 0) continue;
            LOG.info((Object)(cnt + " articles"));
        }
        out.close();
        LOG.info((Object)"Done!");
    }

    public static int[] readDocnoMappingData(Path p, FileSystem fs) throws IOException {
        FSDataInputStream in = fs.open(p);
        int sz = in.readInt() + 1;
        int[] arr = new int[sz];
        for (int i = 1; i < sz; ++i) {
            arr[i] = in.readInt();
        }
        in.close();
        arr[0] = 0;
        return arr;
    }

    @Override
    public DocnoMapping.Builder getBuilder() {
        return new WikipediaDocnoMappingBuilder();
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("usage: (getDocno|getDocid|printAll) [mapping-file] [docid/docno]");
            System.exit(-1);
        }
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        System.out.println("loading mapping file " + args[1]);
        WikipediaDocnoMapping mapping = new WikipediaDocnoMapping();
        mapping.loadMapping(new Path(args[1]), fs);
        if (args[0].equals("getDocno")) {
            System.out.println("looking up docno for \"" + args[2] + "\"");
            int idx = mapping.getDocno(args[2]);
            if (idx > 0) {
                System.out.println(mapping.getDocno(args[2]));
            } else {
                System.err.print("Invalid docid!");
            }
        } else if (args[0].equals("getDocid")) {
            try {
                System.out.println("looking up docid for " + args[2]);
                System.out.println(mapping.getDocid(Integer.parseInt(args[2])));
            }
            catch (Exception e) {
                System.err.print("Invalid docno!");
            }
        } else if (args[0].equals("printAll")) {
            for (int docno = 1; docno < mapping.docids.length; ++docno) {
                System.out.println(mapping.getDocid(docno) + "\t" + docno);
            }
        } else {
            System.out.println("Invalid command!");
            System.out.println("usage: (getDocno|getDocid) [mapping-file] [docid/docno]");
        }
    }
}

