/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.wikipedia;

import edu.umd.cloud9.collection.DocnoMapping;
import edu.umd.cloud9.collection.wikipedia.WikipediaDocnoMapping;
import edu.umd.cloud9.collection.wikipedia.WikipediaPage;
import edu.umd.cloud9.collection.wikipedia.WikipediaPageInputFormat;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Random;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class WikipediaDocnoMappingBuilder
extends Configured
implements Tool,
DocnoMapping.Builder {
    private static final Logger LOG = Logger.getLogger(WikipediaDocnoMappingBuilder.class);
    private static final Random RANDOM = new Random();
    public static final String INPUT_OPTION = "input";
    public static final String OUTPUT_FILE_OPTION = "output_file";
    public static final String KEEP_ALL_OPTION = "keep_all";
    public static final String LANGUAGE_OPTION = "wiki_language";

    @Override
    public int build(Path src, Path dest, Configuration conf) throws IOException {
        super.setConf(conf);
        try {
            return this.run(new String[]{"-input=" + src.toString(), "-output_file=" + dest.toString()});
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public int run(String[] args) throws Exception {
        CommandLine cmdline;
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"XML dump file");
        options.addOption(OptionBuilder.create((String)INPUT_OPTION));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"output file");
        options.addOption(OptionBuilder.create((String)OUTPUT_FILE_OPTION));
        OptionBuilder.withArgName((String)"en|sv|de|cs|es|zh|ar|tr");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"two-letter language code");
        options.addOption(OptionBuilder.create((String)LANGUAGE_OPTION));
        options.addOption(KEEP_ALL_OPTION, false, "keep all pages");
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            return -1;
        }
        if (!cmdline.hasOption(INPUT_OPTION) || !cmdline.hasOption(OUTPUT_FILE_OPTION)) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(this.getClass().getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        String language = null;
        if (cmdline.hasOption(LANGUAGE_OPTION) && (language = cmdline.getOptionValue(LANGUAGE_OPTION)).length() != 2) {
            System.err.println("Error: \"" + language + "\" unknown language!");
            return -1;
        }
        String inputPath = cmdline.getOptionValue(INPUT_OPTION);
        String outputFile = cmdline.getOptionValue(OUTPUT_FILE_OPTION);
        boolean keepAll = cmdline.hasOption(KEEP_ALL_OPTION);
        String tmpPath = "tmp-" + WikipediaDocnoMappingBuilder.class.getSimpleName() + "-" + RANDOM.nextInt(10000);
        LOG.info((Object)("Tool name: " + this.getClass().getName()));
        LOG.info((Object)(" - input: " + inputPath));
        LOG.info((Object)(" - output file: " + outputFile));
        LOG.info((Object)(" - keep all pages: " + keepAll));
        LOG.info((Object)(" - language: " + language));
        Job job = Job.getInstance((Configuration)this.getConf());
        job.setJarByClass(WikipediaDocnoMappingBuilder.class);
        job.setJobName(String.format("BuildWikipediaDocnoMapping[%s: %s, %s: %s, %s: %s]", INPUT_OPTION, inputPath, OUTPUT_FILE_OPTION, outputFile, LANGUAGE_OPTION, language));
        job.getConfiguration().setBoolean(KEEP_ALL_OPTION, keepAll);
        if (language != null) {
            job.getConfiguration().set("wiki.language", language);
        }
        job.setNumReduceTasks(1);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(inputPath)});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(tmpPath));
        FileOutputFormat.setCompressOutput((Job)job, (boolean)false);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(IntWritable.class);
        job.setInputFormatClass(WikipediaPageInputFormat.class);
        job.setOutputFormatClass(TextOutputFormat.class);
        job.setMapperClass(MyMapper.class);
        job.setReducerClass(MyReducer.class);
        FileSystem.get((Configuration)this.getConf()).delete(new Path(tmpPath), true);
        job.waitForCompletion(true);
        long cnt = keepAll ? job.getCounters().findCounter((Enum)PageTypes.TOTAL).getValue() : job.getCounters().findCounter((Enum)PageTypes.ARTICLE).getValue();
        WikipediaDocnoMapping.writeDocnoMappingData(FileSystem.get((Configuration)this.getConf()), tmpPath + "/part-r-00000", (int)cnt, outputFile);
        FileSystem.get((Configuration)this.getConf()).delete(new Path(tmpPath), true);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new WikipediaDocnoMappingBuilder(), (String[])args);
    }

    private static class MyReducer
    extends Reducer<IntWritable, IntWritable, IntWritable, IntWritable> {
        private static final IntWritable cnt = new IntWritable(1);

        private MyReducer() {
        }

        public void reduce(IntWritable key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            context.write((Object)key, (Object)cnt);
            cnt.set(cnt.get() + 1);
        }
    }

    private static class MyMapper
    extends Mapper<LongWritable, WikipediaPage, IntWritable, IntWritable> {
        private static final IntWritable keyOut = new IntWritable();
        private static final IntWritable valOut = new IntWritable(1);
        private boolean keepAll;

        private MyMapper() {
        }

        public void setup(Mapper.Context context) {
            this.keepAll = context.getConfiguration().getBoolean(WikipediaDocnoMappingBuilder.KEEP_ALL_OPTION, false);
        }

        public void map(LongWritable key, WikipediaPage p, Mapper.Context context) throws IOException, InterruptedException {
            context.getCounter((Enum)PageTypes.TOTAL).increment(1L);
            if (this.keepAll) {
                keyOut.set(Integer.parseInt(p.getDocid()));
                context.write((Object)keyOut, (Object)valOut);
                return;
            }
            if (p.isRedirect()) {
                context.getCounter((Enum)PageTypes.REDIRECT).increment(1L);
            } else if (p.isEmpty()) {
                context.getCounter((Enum)PageTypes.EMPTY).increment(1L);
            } else if (p.isDisambiguation()) {
                context.getCounter((Enum)PageTypes.DISAMBIGUATION).increment(1L);
            } else if (p.isArticle()) {
                if ((double)p.getTitle().length() > 0.3 * (double)p.getContent().length()) {
                    context.getCounter((Enum)PageTypes.OTHER).increment(1L);
                    return;
                }
                context.getCounter((Enum)PageTypes.ARTICLE).increment(1L);
                if (p.isStub()) {
                    context.getCounter((Enum)PageTypes.STUB).increment(1L);
                }
                keyOut.set(Integer.parseInt(p.getDocid()));
                context.write((Object)keyOut, (Object)valOut);
            } else {
                context.getCounter((Enum)PageTypes.NON_ARTICLE).increment(1L);
            }
        }
    }

    private static enum PageTypes {
        TOTAL,
        REDIRECT,
        DISAMBIGUATION,
        EMPTY,
        ARTICLE,
        STUB,
        NON_ARTICLE,
        OTHER;

    }
}

