/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.wikipedia;

import edu.umd.cloud9.collection.wikipedia.WikipediaForwardIndex;
import edu.umd.cloud9.collection.wikipedia.WikipediaPage;
import edu.umd.cloud9.collection.wikipedia.language.WikipediaPageFactory;
import edu.umd.cloud9.mapred.NoSplitSequenceFileInputFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Random;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapRunnable;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.util.LineReader;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class WikipediaForwardIndexBuilder
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(WikipediaForwardIndexBuilder.class);
    private static final Random RANDOM = new Random();
    private static final String INPUT_OPTION = "input";
    private static final String INDEX_FILE_OPTION = "index_file";
    private static final String LANGUAGE_OPTION = "wiki_language";

    public int run(String[] args) throws Exception {
        CommandLine cmdline;
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)INPUT_OPTION);
        options.addOption(OptionBuilder.create((String)INPUT_OPTION));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"index file");
        options.addOption(OptionBuilder.create((String)INDEX_FILE_OPTION));
        OptionBuilder.withArgName((String)"en|sv|de|cs|es|zh|ar|tr");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"two-letter language code");
        options.addOption(OptionBuilder.create((String)LANGUAGE_OPTION));
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            return -1;
        }
        if (!cmdline.hasOption(INPUT_OPTION) || !cmdline.hasOption(INDEX_FILE_OPTION)) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(((Object)((Object)this)).getClass().getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        Path inputPath = new Path(cmdline.getOptionValue(INPUT_OPTION));
        String indexFile = cmdline.getOptionValue(INDEX_FILE_OPTION);
        String tmpPath = "tmp-" + WikipediaForwardIndexBuilder.class.getSimpleName() + "-" + RANDOM.nextInt(10000);
        if (!inputPath.isAbsolute()) {
            System.err.println("Error: input must be an absolute path!");
            return -1;
        }
        String language = null;
        if (cmdline.hasOption(LANGUAGE_OPTION) && (language = cmdline.getOptionValue(LANGUAGE_OPTION)).length() != 2) {
            System.err.println("Error: \"" + language + "\" unknown language!");
            return -1;
        }
        JobConf conf = new JobConf(this.getConf(), WikipediaForwardIndexBuilder.class);
        FileSystem fs = FileSystem.get((Configuration)conf);
        LOG.info((Object)("Tool name: " + ((Object)((Object)this)).getClass().getName()));
        LOG.info((Object)(" - input path: " + inputPath));
        LOG.info((Object)(" - index file: " + indexFile));
        LOG.info((Object)(" - language: " + language));
        LOG.info((Object)"Note: This tool only works on block-compressed SequenceFiles!");
        conf.setJobName(String.format("BuildWikipediaForwardIndex[%s: %s, %s: %s, %s: %s]", INPUT_OPTION, inputPath, INDEX_FILE_OPTION, indexFile, LANGUAGE_OPTION, language));
        conf.setNumReduceTasks(1);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inputPath});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(tmpPath));
        FileOutputFormat.setCompressOutput((JobConf)conf, (boolean)false);
        if (language != null) {
            conf.set("wiki.language", language);
        }
        conf.setInputFormat(NoSplitSequenceFileInputFormat.class);
        conf.setOutputKeyClass(IntWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapRunnerClass(MyMapRunner.class);
        conf.setReducerClass(IdentityReducer.class);
        fs.delete(new Path(tmpPath), true);
        RunningJob job = JobClient.runJob((JobConf)conf);
        Counters counters = job.getCounters();
        int blocks = (int)counters.getCounter((Enum)Blocks.Total);
        LOG.info((Object)("number of blocks: " + blocks));
        LOG.info((Object)"Writing index file...");
        LineReader reader = new LineReader((InputStream)fs.open(new Path(tmpPath + "/part-00000")));
        FSDataOutputStream out = fs.create(new Path(indexFile), true);
        out.writeUTF(WikipediaForwardIndex.class.getCanonicalName());
        out.writeUTF(inputPath.toString());
        out.writeInt(blocks);
        int cnt = 0;
        Text line = new Text();
        while (reader.readLine(line) > 0) {
            String[] arr = line.toString().split("\\s+");
            int docno = Integer.parseInt(arr[0]);
            int offset = Integer.parseInt(arr[1]);
            short fileno = Short.parseShort(arr[2]);
            out.writeInt(docno);
            out.writeInt(offset);
            out.writeShort((int)fileno);
            if (++cnt % 100000 != 0) continue;
            LOG.info((Object)(cnt + " blocks written"));
        }
        reader.close();
        out.close();
        if (cnt != blocks) {
            throw new RuntimeException("Error: mismatch in block count!");
        }
        fs.delete(new Path(tmpPath), true);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new WikipediaForwardIndexBuilder(), (String[])args);
    }

    private static class MyMapRunner
    implements MapRunnable<IntWritable, WikipediaPage, IntWritable, Text> {
        private static final IntWritable keyOut = new IntWritable();
        private static final Text valOut = new Text();
        private int fileno;
        private String language;

        private MyMapRunner() {
        }

        public void configure(JobConf job) {
            String file = job.get("map.input.file");
            this.fileno = Integer.parseInt(file.substring(file.indexOf("part-m-") + 7));
            this.language = job.get("wiki.language");
        }

        public void run(RecordReader<IntWritable, WikipediaPage> input, OutputCollector<IntWritable, Text> output, Reporter reporter) throws IOException {
            IntWritable key = new IntWritable();
            WikipediaPage value = WikipediaPageFactory.createWikipediaPage(this.language);
            long pos = -1L;
            long prevPos = -1L;
            int prevDocno = 0;
            pos = input.getPos();
            while (input.next((Object)key, (Object)value)) {
                if (prevPos != -1L && prevPos != pos) {
                    LOG.info((Object)("- beginning of block at " + prevPos + ", docno:" + prevDocno + ", file:" + this.fileno));
                    keyOut.set(prevDocno);
                    valOut.set(prevPos + "\t" + this.fileno);
                    output.collect((Object)keyOut, (Object)valOut);
                    reporter.incrCounter((Enum)Blocks.Total, 1L);
                }
                prevPos = pos;
                pos = input.getPos();
                prevDocno = key.get();
            }
        }
    }

    private static enum Blocks {
        Total;

    }
}

