/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.wikipedia;

import edu.umd.cloud9.collection.IndexableFileInputFormat;
import edu.umd.cloud9.collection.XMLInputFormat;
import edu.umd.cloud9.collection.wikipedia.WikipediaPage;
import edu.umd.cloud9.collection.wikipedia.language.WikipediaPageFactory;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class WikipediaPageInputFormat
extends IndexableFileInputFormat<LongWritable, WikipediaPage> {
    public RecordReader<LongWritable, WikipediaPage> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new WikipediaPageRecordReader();
    }

    public static class WikipediaPageRecordReader
    extends RecordReader<LongWritable, WikipediaPage> {
        private XMLInputFormat.XMLRecordReader reader = new XMLInputFormat.XMLRecordReader();
        private WikipediaPage page;
        private String language;

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            conf.set("xmlinput.start", "<page>");
            conf.set("xmlinput.end", "</page>");
            this.language = conf.get("wiki.language", "en");
            this.page = WikipediaPageFactory.createWikipediaPage(this.language);
            this.reader.initialize(split, context);
        }

        public LongWritable getCurrentKey() throws IOException, InterruptedException {
            return this.reader.getCurrentKey();
        }

        public WikipediaPage getCurrentValue() throws IOException, InterruptedException {
            WikipediaPage.readPage(this.page, this.reader.getCurrentValue().toString());
            return this.page;
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            return this.reader.nextKeyValue();
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public float getProgress() throws IOException, InterruptedException {
            return this.reader.getProgress();
        }
    }
}

