/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.wikipedia;

import edu.umd.cloud9.collection.wikipedia.WikipediaPage;
import edu.umd.cloud9.collection.wikipedia.language.WikipediaPageFactory;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tools.bzip2.CBZip2InputStream;

public class WikipediaPagesBz2InputStream {
    private static int DEFAULT_STRINGBUFFER_CAPACITY = 1024;
    private BufferedReader br = null;
    private FileInputStream fis;
    private static final String INPUT_OPTION = "input";
    private static final String LANGUAGE_OPTION = "output";

    public WikipediaPagesBz2InputStream(String file) throws IOException {
        this.fis = new FileInputStream(file);
        byte[] ignoreBytes = new byte[2];
        this.fis.read(ignoreBytes);
        this.br = new BufferedReader(new InputStreamReader((InputStream)new CBZip2InputStream((InputStream)this.fis)));
    }

    public boolean readNext(WikipediaPage page) throws IOException {
        String s = null;
        StringBuffer sb = new StringBuffer(DEFAULT_STRINGBUFFER_CAPACITY);
        while ((s = this.br.readLine()) != null && !s.endsWith("<page>")) {
        }
        if (s == null) {
            this.fis.close();
            this.br.close();
            return false;
        }
        sb.append(s + "\n");
        while ((s = this.br.readLine()) != null) {
            sb.append(s + "\n");
            if (!s.endsWith("</page>")) continue;
        }
        WikipediaPage.readPage(page, sb.toString());
        return true;
    }

    public static void main(String[] args) throws Exception {
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"gzipped XML dump file");
        options.addOption(OptionBuilder.create((String)INPUT_OPTION));
        OptionBuilder.withArgName((String)"lang");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"output location");
        options.addOption(OptionBuilder.create((String)LANGUAGE_OPTION));
        CommandLine cmdline = null;
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            System.exit(-1);
        }
        if (!cmdline.hasOption(INPUT_OPTION)) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(WikipediaPagesBz2InputStream.class.getCanonicalName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            System.exit(-1);
        }
        String path = cmdline.getOptionValue(INPUT_OPTION);
        String lang = cmdline.hasOption(LANGUAGE_OPTION) ? cmdline.getOptionValue(LANGUAGE_OPTION) : "en";
        WikipediaPage p = WikipediaPageFactory.createWikipediaPage(lang);
        WikipediaPagesBz2InputStream stream = new WikipediaPagesBz2InputStream(path);
        while (stream.readNext(p)) {
            System.out.println(p.getTitle() + "\t" + p.getDocid());
        }
    }
}

