/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.wikipedia.language;

import edu.umd.cloud9.collection.wikipedia.WikipediaPage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public class GermanWikipediaPage
extends WikipediaPage {
    private static final String IDENTIFIER_REDIRECTION_UPPERCASE = "#REDIRECT";
    private static final String IDENTIFIER_REDIRECTION_LOWERCASE = "#redirect";
    private static final String IDENTIFIER_REDIRECTION_UPPERCASE_DE = "#WEITERLEITUNG";
    private static final String IDENTIFIER_REDIRECTION_LOWERCASE_DE = "#weiterleitung";
    private static final String IDENTIFIER_REDIRECTION_CAPITALIZED_DE = "#Weiterleitung";
    private static final String IDENTIFIER_STUB_TEMPLATE = "stub}}";
    private static final String IDENTIFIER_STUB_WIKIPEDIA_NAMESPACE = "Wikipedia:Stub";
    private static final Pattern disambPattern = Pattern.compile("\\{\\{begriffskl\u00e4rung\\}\\}", 2);
    private static final String LANGUAGE_CODE = "de";

    @Override
    protected void processPage(String s) {
        this.language = LANGUAGE_CODE;
        int start = s.indexOf("<title>");
        int end = s.indexOf("</title>", start);
        this.title = StringEscapeUtils.unescapeHtml((String)s.substring(start + 7, end));
        start = s.indexOf("<ns>");
        end = s.indexOf("</ns>");
        this.isArticle = s.substring(start + 4, end).trim().equals("0");
        start = s.indexOf("<id>");
        end = s.indexOf("</id>");
        this.mId = s.substring(start + 4, end);
        this.textStart = s.indexOf("<text xml:space=\"preserve\">");
        this.textEnd = s.indexOf("</text>", this.textStart);
        Matcher matcher = disambPattern.matcher(this.page);
        this.isDisambig = matcher.find();
        this.isRedirect = s.substring(this.textStart + "<text xml:space=\"preserve\">".length(), this.textStart + "<text xml:space=\"preserve\">".length() + IDENTIFIER_REDIRECTION_UPPERCASE.length()).compareTo(IDENTIFIER_REDIRECTION_UPPERCASE) == 0 || s.substring(this.textStart + "<text xml:space=\"preserve\">".length(), this.textStart + "<text xml:space=\"preserve\">".length() + IDENTIFIER_REDIRECTION_LOWERCASE.length()).compareTo(IDENTIFIER_REDIRECTION_LOWERCASE) == 0 || s.substring(this.textStart + "<text xml:space=\"preserve\">".length(), this.textStart + "<text xml:space=\"preserve\">".length() + IDENTIFIER_REDIRECTION_UPPERCASE_DE.length()).compareTo(IDENTIFIER_REDIRECTION_UPPERCASE_DE) == 0 || s.substring(this.textStart + "<text xml:space=\"preserve\">".length(), this.textStart + "<text xml:space=\"preserve\">".length() + IDENTIFIER_REDIRECTION_LOWERCASE_DE.length()).compareTo(IDENTIFIER_REDIRECTION_LOWERCASE_DE) == 0 || s.substring(this.textStart + "<text xml:space=\"preserve\">".length(), this.textStart + "<text xml:space=\"preserve\">".length() + IDENTIFIER_REDIRECTION_CAPITALIZED_DE.length()).compareTo(IDENTIFIER_REDIRECTION_CAPITALIZED_DE) == 0;
        this.isStub = s.indexOf(IDENTIFIER_STUB_TEMPLATE, this.textStart) != -1 || s.indexOf(IDENTIFIER_STUB_WIKIPEDIA_NAMESPACE) != -1;
    }
}

