/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.bfs;

import edu.umd.cloud9.example.bfs.BfsNode;
import edu.umd.cloud9.io.array.ArrayListOfIntsWritable;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class BfsNodeTest {
    @org.junit.Test
    public void testSerialize() throws IOException {
        BfsNode node1 = new BfsNode();
        node1.setType(BfsNode.Type.Complete);
        node1.setNodeId(1);
        node1.setDistance(2);
        node1.setAdjacencyList(new ArrayListOfIntsWritable(new int[]{1, 2, 3, 4, 5, 6}));
        byte[] bytes = node1.serialize();
        BfsNode node2 = BfsNode.create(bytes);
        Assert.assertEquals((long)2L, (long)node2.getDistance());
        Assert.assertEquals((Object)((Object)BfsNode.Type.Complete), (Object)((Object)node2.getType()));
        ArrayListOfIntsWritable adj = node2.getAdjacenyList();
        Assert.assertEquals((long)6L, (long)adj.size());
        Assert.assertEquals((long)1L, (long)adj.get(0));
        Assert.assertEquals((long)2L, (long)adj.get(1));
        Assert.assertEquals((long)3L, (long)adj.get(2));
        Assert.assertEquals((long)4L, (long)adj.get(3));
        Assert.assertEquals((long)5L, (long)adj.get(4));
        Assert.assertEquals((long)6L, (long)adj.get(5));
    }

    @org.junit.Test
    public void testToString() throws Exception {
        BfsNode node = new BfsNode();
        node.setType(BfsNode.Type.Complete);
        node.setNodeId(1);
        node.setDistance(1);
        Assert.assertEquals((Object)"{1 1 []}", (Object)node.toString());
        node.setAdjacencyList(new ArrayListOfIntsWritable(new int[]{1, 2, 3, 4, 5, 6}));
        Assert.assertEquals((Object)"{1 1 [1, 2, 3, 4, 5, 6]}", (Object)node.toString());
        node.setAdjacencyList(new ArrayListOfIntsWritable(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}));
        Assert.assertEquals((Object)"{1 1 [1, 2, 3, 4, 5, 6, 7, 8, 9, 10 ... (2 more) ]}", (Object)node.toString());
    }

    public static Test suite() {
        return new JUnit4TestAdapter(BfsNodeTest.class);
    }
}

