/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.bfs;

import edu.umd.cloud9.example.bfs.BfsNode;
import edu.umd.cloud9.io.array.ArrayListOfIntsWritable;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class EncodeBfsGraph
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(EncodeBfsGraph.class);
    private static final String INPUT_OPTION = "input";
    private static final String OUTPUT_OPTION = "output";
    private static final String SRC_OPTION = "src";

    public int run(String[] args) throws Exception {
        CommandLine cmdline;
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"XML dump file");
        options.addOption(OptionBuilder.create((String)INPUT_OPTION));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"output path");
        options.addOption(OptionBuilder.create((String)OUTPUT_OPTION));
        OptionBuilder.withArgName((String)"nodeid");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"source node");
        options.addOption(OptionBuilder.create((String)SRC_OPTION));
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            return -1;
        }
        if (!(cmdline.hasOption(INPUT_OPTION) && cmdline.hasOption(OUTPUT_OPTION) && cmdline.hasOption(SRC_OPTION))) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(((Object)((Object)this)).getClass().getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        String inputPath = cmdline.getOptionValue(INPUT_OPTION);
        String outputPath = cmdline.getOptionValue(OUTPUT_OPTION);
        int src = Integer.parseInt(cmdline.getOptionValue(SRC_OPTION));
        LOG.info((Object)("Tool name: " + ((Object)((Object)this)).getClass().getName()));
        LOG.info((Object)(" - inputDir: " + inputPath));
        LOG.info((Object)(" - outputDir: " + outputPath));
        LOG.info((Object)(" - src: " + src));
        Job job = Job.getInstance((Configuration)this.getConf());
        job.setJobName(String.format("EncodeBfsGraph[%s: %s, %s: %s, %s: %d]", INPUT_OPTION, inputPath, OUTPUT_OPTION, outputPath, SRC_OPTION, src));
        job.setJarByClass(EncodeBfsGraph.class);
        job.setNumReduceTasks(0);
        job.getConfiguration().setInt(SRC_OPTION, src);
        job.getConfiguration().setInt("mapred.min.split.size", 0x40000000);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(inputPath));
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputPath));
        job.setInputFormatClass(TextInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(BfsNode.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(BfsNode.class);
        job.setMapperClass(MyMapper.class);
        FileSystem.get((Configuration)job.getConfiguration()).delete(new Path(outputPath), true);
        job.waitForCompletion(true);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Tool)new EncodeBfsGraph(), (String[])args);
        System.exit(res);
    }

    private static class MyMapper
    extends Mapper<LongWritable, Text, IntWritable, BfsNode> {
        private static final IntWritable nid = new IntWritable();
        private static final BfsNode node = new BfsNode();
        private static int src;

        private MyMapper() {
        }

        public void setup(Mapper.Context context) {
            src = context.getConfiguration().getInt(EncodeBfsGraph.SRC_OPTION, 0);
            node.setType(BfsNode.Type.Complete);
        }

        public void map(LongWritable key, Text t, Mapper.Context context) throws IOException, InterruptedException {
            String[] arr = t.toString().trim().split("\\s+");
            int cur = Integer.parseInt(arr[0]);
            nid.set(cur);
            node.setNodeId(cur);
            node.setDistance(cur == src ? 0 : Integer.MAX_VALUE);
            if (arr.length == 1) {
                node.setAdjacencyList(new ArrayListOfIntsWritable());
            } else {
                int[] neighbors = new int[arr.length - 1];
                for (int i = 1; i < arr.length; ++i) {
                    neighbors[i - 1] = Integer.parseInt(arr[i]);
                }
                node.setAdjacencyList(new ArrayListOfIntsWritable(neighbors));
            }
            context.getCounter((Enum)Graph.Nodes).increment(1L);
            context.getCounter((Enum)Graph.Edges).increment((long)(arr.length - 1));
            context.write((Object)nid, (Object)node);
        }
    }

    private static enum Graph {
        Nodes,
        Edges;

    }
}

