/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.bfs;

import edu.umd.cloud9.example.bfs.BfsNode;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class FindNodeAtDistance
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(FindNodeAtDistance.class);
    private static final String INPUT_OPTION = "input";
    private static final String OUTPUT_OPTION = "output";
    private static final String DISTANCE_OPTION = "distance";

    public int run(String[] args) throws Exception {
        CommandLine cmdline;
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"XML dump file");
        options.addOption(OptionBuilder.create((String)INPUT_OPTION));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"output path");
        options.addOption(OptionBuilder.create((String)OUTPUT_OPTION));
        OptionBuilder.withArgName((String)"num");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)DISTANCE_OPTION);
        options.addOption(OptionBuilder.create((String)DISTANCE_OPTION));
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            return -1;
        }
        if (!(cmdline.hasOption(INPUT_OPTION) && cmdline.hasOption(OUTPUT_OPTION) && cmdline.hasOption(DISTANCE_OPTION))) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(((Object)((Object)this)).getClass().getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        String inputPath = cmdline.getOptionValue(INPUT_OPTION);
        String outputPath = cmdline.getOptionValue(OUTPUT_OPTION);
        int distance = Integer.parseInt(cmdline.getOptionValue(DISTANCE_OPTION));
        LOG.info((Object)("Tool name: " + ((Object)((Object)this)).getClass().getName()));
        LOG.info((Object)(" - inputDir: " + inputPath));
        LOG.info((Object)(" - outputDir: " + outputPath));
        LOG.info((Object)(" - distance: " + distance));
        Job job = Job.getInstance((Configuration)this.getConf());
        job.setJobName(String.format("FindNodeAtDistance[%s: %s, %s: %s, %s: %d]", INPUT_OPTION, inputPath, OUTPUT_OPTION, outputPath, DISTANCE_OPTION, distance));
        job.setJarByClass(FindNodeAtDistance.class);
        job.setNumReduceTasks(0);
        job.getConfiguration().setInt(DISTANCE_OPTION, distance);
        job.getConfiguration().setInt("mapred.min.split.size", 0x40000000);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(inputPath));
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputPath));
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputFormatClass(TextOutputFormat.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(BfsNode.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(BfsNode.class);
        job.setMapperClass(MyMapper.class);
        FileSystem.get((Configuration)job.getConfiguration()).delete(new Path(outputPath), true);
        job.waitForCompletion(true);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Tool)new FindNodeAtDistance(), (String[])args);
        System.exit(res);
    }

    private static class MyMapper
    extends Mapper<IntWritable, BfsNode, IntWritable, BfsNode> {
        private static int distance;

        private MyMapper() {
        }

        public void setup(Mapper.Context context) {
            distance = context.getConfiguration().getInt(FindNodeAtDistance.DISTANCE_OPTION, 0);
        }

        public void map(IntWritable nid, BfsNode node, Mapper.Context context) throws IOException, InterruptedException {
            if (node.getDistance() == distance) {
                context.write((Object)nid, (Object)node);
            }
        }
    }
}

