/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.bfs;

import edu.umd.cloud9.example.bfs.BfsNode;
import edu.umd.cloud9.example.bfs.EncodeBfsGraph;
import edu.umd.cloud9.io.array.ArrayListOfIntsWritable;
import edu.umd.cloud9.util.map.HMapII;
import edu.umd.cloud9.util.map.MapII;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class IterateBfs
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(IterateBfs.class);
    private static final String INPUT_OPTION = "input";
    private static final String OUTPUT_OPTION = "output";
    private static final String NUM_PARTITIONS_OPTION = "num_partitions";

    public int run(String[] args) throws Exception {
        CommandLine cmdline;
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"XML dump file");
        options.addOption(OptionBuilder.create((String)INPUT_OPTION));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"output path");
        options.addOption(OptionBuilder.create((String)OUTPUT_OPTION));
        OptionBuilder.withArgName((String)"num");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"number of partitions");
        options.addOption(OptionBuilder.create((String)NUM_PARTITIONS_OPTION));
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            return -1;
        }
        if (!(cmdline.hasOption(INPUT_OPTION) && cmdline.hasOption(OUTPUT_OPTION) && cmdline.hasOption(NUM_PARTITIONS_OPTION))) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(((Object)((Object)this)).getClass().getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        String inputPath = cmdline.getOptionValue(INPUT_OPTION);
        String outputPath = cmdline.getOptionValue(OUTPUT_OPTION);
        int n = Integer.parseInt(cmdline.getOptionValue(NUM_PARTITIONS_OPTION));
        LOG.info((Object)("Tool name: " + ((Object)((Object)this)).getClass().getName()));
        LOG.info((Object)(" - inputDir: " + inputPath));
        LOG.info((Object)(" - outputDir: " + outputPath));
        LOG.info((Object)(" - numPartitions: " + n));
        this.getConf().set("mapred.child.java.opts", "-Xmx2048m");
        Job job = Job.getInstance((Configuration)this.getConf());
        job.setJobName(String.format("IterateBfs[%s: %s, %s: %s, %s: %d]", INPUT_OPTION, inputPath, OUTPUT_OPTION, outputPath, NUM_PARTITIONS_OPTION, n));
        job.setJarByClass(EncodeBfsGraph.class);
        job.setNumReduceTasks(n);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(inputPath));
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputPath));
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(BfsNode.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(BfsNode.class);
        job.setMapperClass(MapClass.class);
        job.setReducerClass(ReduceClass.class);
        FileSystem.get((Configuration)job.getConfiguration()).delete(new Path(outputPath), true);
        job.waitForCompletion(true);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Tool)new IterateBfs(), (String[])args);
        System.exit(res);
    }

    private static class ReduceClass
    extends Reducer<IntWritable, BfsNode, IntWritable, BfsNode> {
        private static final BfsNode node = new BfsNode();

        private ReduceClass() {
        }

        public void reduce(IntWritable nid, Iterable<BfsNode> iterable, Reducer.Context context) throws IOException, InterruptedException {
            Iterator<BfsNode> values = iterable.iterator();
            int structureReceived = 0;
            int dist = Integer.MAX_VALUE;
            while (values.hasNext()) {
                BfsNode n = values.next();
                if (n.getType() == BfsNode.Type.Structure) {
                    ArrayListOfIntsWritable list = n.getAdjacenyList();
                    ++structureReceived;
                    int[] arr = new int[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        arr[i] = list.get(i);
                    }
                    node.setAdjacencyList(new ArrayListOfIntsWritable(arr));
                    continue;
                }
                if (n.getDistance() >= dist) continue;
                dist = n.getDistance();
            }
            node.setType(BfsNode.Type.Complete);
            node.setNodeId(nid.get());
            node.setDistance(dist);
            if (dist != Integer.MAX_VALUE) {
                context.getCounter((Enum)ReachableNodes.ReachableInReducer).increment(1L);
            }
            if (structureReceived == 1) {
                context.write((Object)nid, (Object)node);
            } else if (structureReceived == 0) {
                LOG.warn((Object)("No structure received for nodeid: " + nid.get()));
            } else {
                throw new RuntimeException("Multiple structure received for nodeid: " + nid.get() + " struct: " + structureReceived);
            }
        }
    }

    private static class MapClass
    extends Mapper<IntWritable, BfsNode, IntWritable, BfsNode> {
        private static final HMapII map = new HMapII();
        private static final BfsNode intermediateStructure = new BfsNode();

        private MapClass() {
        }

        public void map(IntWritable nid, BfsNode node, Mapper.Context context) throws IOException, InterruptedException {
            intermediateStructure.setNodeId(node.getNodeId());
            intermediateStructure.setType(BfsNode.Type.Structure);
            intermediateStructure.setAdjacencyList(node.getAdjacenyList());
            context.write((Object)nid, (Object)intermediateStructure);
            if (node.getDistance() == Integer.MAX_VALUE) {
                return;
            }
            context.getCounter((Enum)ReachableNodes.ReachableInMapper).increment(1L);
            map.put(nid.get(), node.getDistance());
            ArrayListOfIntsWritable adj = node.getAdjacenyList();
            int dist = node.getDistance() + 1;
            for (int i = 0; i < adj.size(); ++i) {
                int neighbor = adj.get(i);
                if ((!map.containsKey(neighbor) || dist >= map.get(neighbor)) && map.containsKey(neighbor)) continue;
                map.put(neighbor, dist);
            }
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            IntWritable k = new IntWritable();
            BfsNode dist = new BfsNode();
            for (MapII.Entry e : map.entrySet()) {
                k.set(e.getKey());
                dist.setNodeId(e.getKey());
                dist.setType(BfsNode.Type.Distance);
                dist.setDistance(e.getValue());
                context.write((Object)k, (Object)dist);
            }
        }
    }

    private static enum ReachableNodes {
        ReachableInMapper,
        ReachableInReducer;

    }
}

