/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.bigram;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import edu.umd.cloud9.io.SequenceFileUtils;
import edu.umd.cloud9.io.pair.PairOfStrings;
import edu.umd.cloud9.io.pair.PairOfWritables;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.util.ToolRunner;

public class AnalyzeBigramRelativeFrequency {
    private static final String INPUT = "input";

    public static void main(String[] args) {
        PairOfStrings bigram;
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"input path");
        options.addOption(OptionBuilder.create((String)INPUT));
        CommandLine cmdline = null;
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            System.exit(-1);
        }
        if (!cmdline.hasOption(INPUT)) {
            System.out.println("args: " + Arrays.toString(args));
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(120);
            formatter.printHelp(AnalyzeBigramRelativeFrequency.class.getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            System.exit(-1);
        }
        String inputPath = cmdline.getOptionValue(INPUT);
        System.out.println("input path: " + inputPath);
        List pairs = SequenceFileUtils.readDirectory(new Path(inputPath));
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        for (PairOfWritables pairOfWritables : pairs) {
            bigram = (PairOfStrings)pairOfWritables.getLeftElement();
            if (bigram.getLeftElement().equals("light")) {
                list1.add(pairOfWritables);
            }
            if (!bigram.getLeftElement().equals("contain")) continue;
            list2.add(pairOfWritables);
        }
        Collections.sort(list1, new Comparator<PairOfWritables<PairOfStrings, FloatWritable>>(){

            @Override
            public int compare(PairOfWritables<PairOfStrings, FloatWritable> e1, PairOfWritables<PairOfStrings, FloatWritable> e2) {
                if (e1.getRightElement().compareTo(e2.getRightElement()) == 0) {
                    return e1.getLeftElement().compareTo(e2.getLeftElement());
                }
                return e2.getRightElement().compareTo(e1.getRightElement());
            }
        });
        Iterator iter1 = Iterators.limit(list1.iterator(), (int)10);
        while (iter1.hasNext()) {
            PairOfWritables pairOfWritables = (PairOfWritables)iter1.next();
            bigram = (PairOfStrings)pairOfWritables.getLeftElement();
            System.out.println(bigram + "\t" + pairOfWritables.getRightElement());
        }
        Collections.sort(list2, new Comparator<PairOfWritables<PairOfStrings, FloatWritable>>(){

            @Override
            public int compare(PairOfWritables<PairOfStrings, FloatWritable> e1, PairOfWritables<PairOfStrings, FloatWritable> e2) {
                if (e1.getRightElement().compareTo(e2.getRightElement()) == 0) {
                    return e1.getLeftElement().compareTo(e2.getLeftElement());
                }
                return e2.getRightElement().compareTo(e1.getRightElement());
            }
        });
        Iterator iterator = Iterators.limit(list2.iterator(), (int)10);
        while (iterator.hasNext()) {
            PairOfWritables p = (PairOfWritables)iterator.next();
            PairOfStrings bigram2 = (PairOfStrings)p.getLeftElement();
            System.out.println(bigram2 + "\t" + p.getRightElement());
        }
    }
}

