/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.clustering;

import cern.colt.Arrays;
import edu.umd.cloud9.example.clustering.PVector;
import edu.umd.cloud9.example.clustering.Point;
import edu.umd.cloud9.example.clustering.UnivariateGaussianMixtureModel;
import edu.umd.cloud9.io.pair.PairOfStrings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class IterateGMM
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(IterateGMM.class);
    private static final String INPUT = "input";
    private static final String OUTPUT = "output";
    private static final String NUM_REDUCERS = "numReducers";
    private static final int MAX_ITERATIONS = 30;
    private static final double logLikelihoodThreshold = 1.0E-9;

    private static int printUsage() {
        System.out.println("usage: [input-path] [output-path] [num-reducers]");
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        return -1;
    }

    public int run(String[] args) throws Exception {
        CommandLine cmdline;
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"input path");
        options.addOption(OptionBuilder.create((String)INPUT));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"output path");
        options.addOption(OptionBuilder.create((String)OUTPUT));
        OptionBuilder.withArgName((String)"num");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"number of reducers");
        options.addOption(OptionBuilder.create((String)NUM_REDUCERS));
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            return -1;
        }
        if (!cmdline.hasOption(INPUT) || !cmdline.hasOption(OUTPUT)) {
            System.out.println("args: " + Arrays.toString((Object[])args));
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(120);
            formatter.printHelp(((Object)((Object)this)).getClass().getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        String inputPath0 = cmdline.getOptionValue(INPUT);
        String outputPath = cmdline.getOptionValue(OUTPUT);
        int reduceTasks = cmdline.hasOption(NUM_REDUCERS) ? Integer.parseInt(cmdline.getOptionValue(NUM_REDUCERS)) : 1;
        LOG.info((Object)("Tool: " + IterateGMM.class.getSimpleName()));
        LOG.info((Object)(" - input path: " + inputPath0));
        String inputPath = inputPath0 + "/points";
        LOG.info((Object)(" - output path: " + outputPath));
        LOG.info((Object)(" - number of reducers: " + reduceTasks));
        Configuration conf = this.getConf();
        for (int iterations = 0; iterations == 0 || !IterateGMM.FinishIteration(inputPath0, iterations, conf); ++iterations) {
            LOG.info((Object)("** iterations: " + iterations));
            try {
                Job job = Job.getInstance((Configuration)conf);
                job.setJobName(IterateGMM.class.getSimpleName());
                job.setJarByClass(IterateGMM.class);
                job.getConfiguration().set("clusterpath", inputPath0 + "/cluster" + iterations);
                job.setNumReduceTasks(reduceTasks);
                FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(inputPath)});
                FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputPath));
                job.setMapOutputKeyClass(Text.class);
                job.setMapOutputValueClass(PairOfStrings.class);
                job.setOutputKeyClass(Text.class);
                job.setOutputValueClass(Text.class);
                job.setMapperClass(MyMapper.class);
                job.setReducerClass(MyReducer.class);
                job.setPartitionerClass(MyPartitioner.class);
                Path outputDir = new Path(outputPath);
                FileSystem.get((Configuration)this.getConf()).delete(outputDir, true);
                long startTime = System.currentTimeMillis();
                job.waitForCompletion(true);
                LOG.info((Object)("Job Finished in " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds"));
                IterateGMM.reNameFile(inputPath0, outputPath, iterations + 1, conf, reduceTasks);
                continue;
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new IterateGMM(), (String[])args);
    }

    public static double getlld(String input, int iterations, Configuration conf) {
        try {
            FSDataInputStream cluster = FileSystem.get((Configuration)conf).open(new Path(input + "/cluster" + iterations));
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)cluster));
            UnivariateGaussianMixtureModel model = new UnivariateGaussianMixtureModel();
            double lld = 0.0;
            while (reader.ready()) {
                int j;
                String line = reader.readLine();
                if (line.indexOf("lld") < 0) continue;
                String[] terms = line.split("\\s+");
                for (j = 0; j < terms.length && terms[j].indexOf("lld") < 0; ++j) {
                }
                lld = Double.parseDouble(terms[j + 1]);
                break;
            }
            reader.close();
            cluster.close();
            return lld;
        }
        catch (IOException exp) {
            exp.printStackTrace();
            return 0.0;
        }
    }

    public static boolean FinishIteration(String input, int iterations, Configuration conf) {
        double logLikelihoodOld;
        if (iterations >= 30) {
            return true;
        }
        if (iterations <= 1) {
            return false;
        }
        double logLikelihoodNew = IterateGMM.getlld(input, iterations, conf);
        return !(Math.abs((logLikelihoodNew - (logLikelihoodOld = IterateGMM.getlld(input, iterations - 1, conf))) / logLikelihoodOld) > 1.0E-9);
    }

    public static boolean reNameFile(String input, String output, int iterations, Configuration conf, int reduceTasks) {
        String dstName = input + "/cluster" + iterations;
        try {
            FileSystem fs = FileSystem.get((Configuration)conf);
            fs.delete(new Path(dstName), true);
            FSDataOutputStream clusterfile = fs.create(new Path(dstName));
            for (int i = 0; i < reduceTasks; ++i) {
                String srcName = output + "/part-r-" + String.format("%05d", i);
                FSDataInputStream cluster = fs.open(new Path(srcName));
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)cluster));
                while (reader.ready()) {
                    String line = reader.readLine() + "\n";
                    if (line.length() <= 5) continue;
                    clusterfile.write(line.getBytes());
                }
                reader.close();
                cluster.close();
            }
            clusterfile.flush();
            clusterfile.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected static class MyPartitioner
    extends Partitioner<Text, PairOfStrings> {
        protected MyPartitioner() {
        }

        public int getPartition(Text key, PairOfStrings value, int numReduceTasks) {
            return (key.toString().hashCode() & Integer.MAX_VALUE) % numReduceTasks;
        }
    }

    protected static class MyReducer
    extends Reducer<Text, PairOfStrings, Text, Text> {
        private static final Text result = new Text();

        protected MyReducer() {
        }

        public void reduce(Text key, Iterable<PairOfStrings> values, Reducer.Context context) throws IOException, InterruptedException {
            Iterator<PairOfStrings> iter = values.iterator();
            if (key.toString().matches("lld")) {
                double lld = 0.0;
                while (iter.hasNext()) {
                    lld += Double.parseDouble(iter.next().getRightElement());
                }
                result.set(String.valueOf(lld));
                context.write((Object)key, (Object)result);
            } else {
                double sum = 0.0;
                double mu = 0.0;
                double sigma = 0.0;
                double diff1 = 0.0;
                double diff2 = 0.0;
                double diff3 = 0.0;
                int tot = 0;
                while (iter.hasNext()) {
                    ++tot;
                    PairOfStrings now = iter.next();
                    double w = Double.parseDouble(now.getRightElement());
                    double x = Double.parseDouble(now.getLeftElement());
                    sum += w;
                    mu += x * w;
                    diff1 += x * x * w;
                    diff2 += 2.0 * x * w;
                    diff3 += w;
                }
                sigma = (diff1 - diff2 * (mu /= sum) + diff3 * mu * mu) / sum;
                double weight = sum / (double)tot;
                result.set(String.valueOf(weight) + " " + String.valueOf(mu) + " " + String.valueOf(sigma));
                context.write((Object)key, (Object)result);
            }
        }
    }

    protected static class MyMapper
    extends Mapper<LongWritable, Text, Text, PairOfStrings> {
        private static final Text comp = new Text();
        private static final PairOfStrings PairValue = new PairOfStrings();
        private UnivariateGaussianMixtureModel model = new UnivariateGaussianMixtureModel();
        private final Vector<String> lines = new Vector();
        private double[] p;

        protected MyMapper() {
        }

        public void setup(Mapper.Context context) throws IOException {
            String file = context.getConfiguration().get("clusterpath");
            FSDataInputStream cluster = FileSystem.get((Configuration)context.getConfiguration()).open(new Path(file));
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)cluster));
            this.lines.clear();
            while (reader.ready()) {
                String line = reader.readLine();
                if (line.indexOf("lld") >= 0 || line.length() <= 5) continue;
                this.lines.add(line);
            }
            reader.close();
            cluster.close();
            this.model.setSize(this.lines.size());
            this.p = new double[this.model.size];
            for (int i = 0; i < this.lines.size(); ++i) {
                int j;
                String[] terms = this.lines.elementAt(i).split("\\s+");
                for (j = 0; j < terms.length && terms[j].length() <= 0; ++j) {
                }
                this.model.pos[i] = Integer.parseInt(terms[j]);
                this.model.weight[i] = Double.parseDouble(terms[j + 1]);
                PVector param = new PVector(2);
                param.array[0] = Double.parseDouble(terms[j + 2]);
                param.array[1] = Double.parseDouble(terms[j + 3]);
                this.model.param[i] = param;
            }
            LOG.info((Object)("setup: " + this.model.toString()));
        }

        public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            int k;
            String line = value.toString();
            StringTokenizer itr = new StringTokenizer(line);
            double x = 0.0;
            while (itr.hasMoreTokens()) {
                String curr = itr.nextToken();
                x = Double.parseDouble(curr);
            }
            double lld = Math.log(this.model.density(new Point(x)));
            comp.set("lld");
            PairValue.set(String.valueOf(x), String.valueOf(lld));
            context.write((Object)comp, (Object)PairValue);
            double sum = 0.0;
            for (k = 0; k < this.model.size; ++k) {
                double tmp;
                this.p[k] = tmp = this.model.weight[k] * UnivariateGaussianMixtureModel.densityOfGaussian(new Point(x), this.model.param[k]);
                sum += tmp;
            }
            k = 0;
            while (k < this.model.size) {
                int n = k++;
                this.p[n] = this.p[n] / sum;
            }
            for (int i = 0; i < this.model.size; ++i) {
                comp.set(String.valueOf(this.model.pos[i]));
                PairValue.set(String.valueOf(x), String.valueOf(this.p[i]));
                context.write((Object)comp, (Object)PairValue);
            }
        }
    }
}

