/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.clustering;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import edu.umd.cloud9.example.clustering.ExpectationMaximization;
import edu.umd.cloud9.example.clustering.Point;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class KMeans {
    private static final int MAX_ITERATIONS = 30;

    public static List<Point>[] run(Point[] points, int k) {
        Point[] centroids = KMeans.initialize(points, k);
        int[] repartition = new int[points.length];
        List[] clusters = new List[k];
        int it = 0;
        int[] tmp = new int[points.length];
        do {
            tmp = (int[])repartition.clone();
            KMeans.repartitionStep(points, k, centroids, repartition, clusters);
            KMeans.centroidStep(points, k, centroids, clusters);
        } while (!Arrays.equals(repartition, tmp) && ++it < 30);
        return clusters;
    }

    public static void dumpClusters(List<Point>[] clusters) {
        for (List<Point> cluster : clusters) {
            System.out.println(Lists.transform(cluster, (Function)new Function<Point, Double>(){

                @Nullable
                public Double apply(@Nullable Point point) {
                    return point.value;
                }
            }).toString());
        }
    }

    private static Point[] initialize(Point[] points, int k) {
        Integer[] arr = ExpectationMaximization.sampleNUniquePoints(k, points.length);
        Point[] centroids = new Point[k];
        for (int i = 0; i < k; ++i) {
            centroids[i] = new Point(points[arr[i].intValue()].value);
        }
        return centroids;
    }

    private static void repartitionStep(Point[] points, int k, Point[] centroids, int[] repartition, List<Point>[] clusters) {
        int i;
        for (i = 0; i < k; ++i) {
            clusters[i] = Lists.newArrayList();
        }
        for (i = 0; i < points.length; ++i) {
            int index = 0;
            double dist = Double.MAX_VALUE;
            for (int j = 0; j < k; ++j) {
                double dist_tmp = Math.abs(points[i].value - centroids[j].value);
                if (!(dist_tmp < dist)) continue;
                dist = dist_tmp;
                index = j;
            }
            repartition[i] = index;
            clusters[index].add(points[i]);
        }
    }

    private static void centroidStep(Point[] points, int k, Point[] centroids, List<Point>[] clusters) {
        for (int i = 0; i < k; ++i) {
            centroids[i] = new Point(0.0);
            for (int j = 0; j < clusters[i].size(); ++j) {
                centroids[i].value += clusters[i].get((int)j).value;
            }
            centroids[i].value *= 1.0 / (double)clusters[i].size();
        }
    }
}

