/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.clustering;

import java.util.Arrays;
import java.util.Locale;

public final class PVector {
    private int dim;
    public double[] array;

    public PVector(int dim) {
        this.dim = dim;
        this.array = new double[dim];
    }

    public PVector plus(PVector v2) {
        PVector result = new PVector(this.dim);
        PVector q = v2;
        for (int i = 0; i < q.dim; ++i) {
            result.array[i] = this.array[i] + q.array[i];
        }
        return result;
    }

    public PVector minus(PVector v2) {
        PVector result = new PVector(this.dim);
        PVector q = v2;
        for (int i = 0; i < q.dim; ++i) {
            result.array[i] = this.array[i] - q.array[i];
        }
        return result;
    }

    public PVector times(double lambda) {
        PVector result = new PVector(this.dim);
        for (int i = 0; i < this.dim; ++i) {
            result.array[i] = this.array[i] * lambda;
        }
        return result;
    }

    public double dot(PVector v2) {
        double result = 0.0;
        PVector q = v2;
        for (int i = 0; i < q.dim; ++i) {
            result += this.array[i] * q.array[i];
        }
        return result;
    }

    public static PVector sampleRandomVector(int dim) {
        PVector result = new PVector(dim);
        for (int i = 0; i < dim; ++i) {
            result.array[i] = Math.random();
        }
        return result;
    }

    public static PVector sampleRandomDistribution(int dim) {
        int i;
        PVector result = PVector.sampleRandomVector(dim);
        double cumul = 0.0;
        for (i = 0; i < dim; ++i) {
            cumul += result.array[i];
        }
        i = 0;
        while (i < dim) {
            int n = i++;
            result.array[n] = result.array[n] / cumul;
        }
        return result;
    }

    public static boolean equals(PVector v1, PVector v2) {
        return Arrays.equals(v1.array, v2.array);
    }

    public double norm2() {
        double norm = 0.0;
        for (int i = 0; i < this.array.length; ++i) {
            norm += this.array[i] * this.array[i];
        }
        return Math.sqrt(norm);
    }

    public String toString() {
        String output = "( ";
        for (int i = 0; i < this.dim; ++i) {
            output = output + String.format(Locale.ENGLISH, "%13.6f ", this.array[i]);
        }
        return output + ")";
    }

    public PVector clone() {
        PVector param = new PVector(this.dim);
        param.array = (double[])this.array.clone();
        return param;
    }

    public int getDimension() {
        return this.dim;
    }
}

