/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.clustering;

import edu.umd.cloud9.example.clustering.PVector;
import edu.umd.cloud9.example.clustering.Point;
import java.util.Random;

public class UnivariateGaussianMixtureModel {
    public int size;
    public double[] weight;
    public int[] pos;
    public PVector[] param;

    public UnivariateGaussianMixtureModel() {
        this.size = 0;
    }

    public void setSize(int n) {
        this.size = n;
        this.weight = new double[n];
        this.param = new PVector[n];
        this.pos = new int[n];
    }

    public UnivariateGaussianMixtureModel(int n) {
        this.size = n;
        this.weight = new double[n];
        this.param = new PVector[n];
        this.pos = new int[n];
    }

    public double density(Point x) {
        double cumul = 0.0;
        for (int i = 0; i < this.size; ++i) {
            cumul += this.weight[i] * UnivariateGaussianMixtureModel.densityOfGaussian(x, this.param[i]);
        }
        return cumul;
    }

    public void normalizeWeights() {
        int i;
        double sum = 0.0;
        for (i = 0; i < this.size; ++i) {
            sum += this.weight[i];
        }
        i = 0;
        while (i < this.size) {
            int n = i++;
            this.weight[n] = this.weight[n] / sum;
        }
    }

    public String toString() {
        String output = String.format("Mixture containing %d components\n", this.size);
        for (int i = 0; i < this.size; ++i) {
            output = output + String.format("  Component %4d: ", this.pos[i]);
            output = output + String.format("Weight = %8.6f ", this.weight[i]);
            output = output + String.format("Parameters = %s\n", this.param[i]);
        }
        return output;
    }

    public UnivariateGaussianMixtureModel clone() {
        UnivariateGaussianMixtureModel mm = new UnivariateGaussianMixtureModel(this.size);
        mm.weight = (double[])this.weight.clone();
        mm.pos = (int[])this.pos.clone();
        for (int i = 0; i < this.size; ++i) {
            mm.param[i] = this.param[i].clone();
        }
        return mm;
    }

    public int getDimension() {
        return this.param[0].getDimension();
    }

    public Point[] drawRandomPoints(int m) {
        int i;
        Point[] points = new Point[m];
        int n = this.size;
        double[] t = new double[n];
        double sum = 0.0;
        for (i = 0; i < n; ++i) {
            t[i] = sum += this.weight[i];
        }
        for (i = 0; i < m; ++i) {
            int idx;
            double r = Math.random();
            for (idx = 0; t[idx] < r && idx < n - 1; ++idx) {
            }
            points[i] = UnivariateGaussianMixtureModel.drawRandomPointFromGaussian(this.param[idx]);
        }
        return points;
    }

    public static double densityOfGaussian(Point x, PVector param) {
        return Math.exp(-(x.value - param.array[0]) * (x.value - param.array[0]) / (2.0 * param.array[1])) / Math.sqrt(Math.PI * 2 * param.array[1]);
    }

    public static Point drawRandomPointFromGaussian(PVector L) {
        double mean = L.array[0];
        double variance = L.array[1];
        Random rand = new Random();
        return new Point(mean + rand.nextGaussian() * Math.sqrt(variance));
    }
}

