/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.hits;

import edu.umd.cloud9.example.hits.HITSNode;
import edu.umd.cloud9.io.array.ArrayListOfIntsWritable;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class HFormatterWG
extends Configured
implements Tool {
    private static final Logger sLogger = Logger.getLogger(HFormatterWG.class);

    private static int printUsage() {
        System.out.println("usage: [input-path] [output-path] [num-mappers] [num-reducers] [stoplist-path]");
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        return -1;
    }

    public int run(String[] args) throws Exception {
        if (args.length != 5) {
            HFormatterWG.printUsage();
            return -1;
        }
        String inputPath = args[0];
        String outputPath = args[1];
        int mapTasks = Integer.parseInt(args[2]);
        int reduceTasks = Integer.parseInt(args[3]);
        String stoplistPath = args[4];
        sLogger.info((Object)"Tool: HFormatterWG");
        sLogger.info((Object)(" - input path: " + inputPath));
        sLogger.info((Object)(" - output path: " + outputPath));
        sLogger.info((Object)(" - number of mappers: " + mapTasks));
        sLogger.info((Object)(" - number of reducers: " + reduceTasks));
        JobConf conf = new JobConf(HFormatterWG.class);
        conf.setJobName("HubFormatter -- WebGraph");
        conf.setNumMapTasks(mapTasks);
        conf.setNumReduceTasks(reduceTasks);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{new Path(inputPath)});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(outputPath));
        FileOutputFormat.setCompressOutput((JobConf)conf, (boolean)false);
        conf.setOutputKeyClass(IntWritable.class);
        conf.setOutputValueClass(HITSNode.class);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        conf.setMapperClass(HFormatMapper.class);
        conf.setReducerClass(HFormatReducer.class);
        Path outputDir = new Path(outputPath);
        Path stopList = new Path(stoplistPath);
        FileSystem.get((Configuration)conf).delete(outputDir, true);
        long startTime = System.currentTimeMillis();
        DistributedCache.addCacheFile((URI)stopList.toUri(), (Configuration)conf);
        conf.setStrings("stoplist", new String[]{stopList.toString()});
        JobClient.runJob((JobConf)conf);
        sLogger.info((Object)("Job Finished in " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds"));
        return 0;
    }

    private static HashSet<Integer> readStopList(JobConf jc) {
        HashSet<Integer> out = new HashSet<Integer>();
        try {
            String line;
            Path[] cacheFiles = DistributedCache.getLocalCacheFiles((Configuration)jc);
            FileReader fr = new FileReader(cacheFiles[0].toString());
            BufferedReader stopReader = new BufferedReader(fr);
            while ((line = stopReader.readLine()) != null) {
                out.add(Integer.parseInt(line));
            }
            stopReader.close();
            return out;
        }
        catch (IOException ioe) {
            System.err.println("IOException reading from distributed cache");
            System.err.println(ioe.toString());
            return out;
        }
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new HFormatterWG(), (String[])args);
        System.exit(res);
    }

    private static class HFormatReducer
    extends MapReduceBase
    implements Reducer<IntWritable, HITSNode, IntWritable, HITSNode> {
        ArrayListOfIntsWritable adjList = new ArrayListOfIntsWritable();
        private HITSNode valIn;
        private HITSNode valOut = new HITSNode();

        private HFormatReducer() {
        }

        public void reduce(IntWritable key, Iterator<HITSNode> values, OutputCollector<IntWritable, HITSNode> output, Reporter reporter) throws IOException {
            this.adjList.clear();
            while (values.hasNext()) {
                this.valIn = values.next();
                ArrayListOfIntsWritable adjListIn = this.valIn.getOutlinks();
                adjListIn.trimToSize();
                this.adjList.addUnique(adjListIn.getArray());
                this.valOut.setNodeId(this.valIn.getNodeId());
            }
            this.valOut.setOutlinks(this.adjList);
            this.valOut.setType(1);
            this.valOut.setHRank(0.0f);
            output.collect((Object)key, (Object)this.valOut);
        }
    }

    private static class HFormatMapper
    extends MapReduceBase
    implements Mapper<LongWritable, Text, IntWritable, HITSNode> {
        private IntWritable keyOut = new IntWritable();
        HashSet<Integer> stopList = new HashSet();

        private HFormatMapper() {
        }

        public void configure(JobConf jc) {
            this.stopList = HFormatterWG.readStopList(jc);
        }

        public void map(LongWritable key, Text value, OutputCollector<IntWritable, HITSNode> output, Reporter reporter) throws IOException {
            int curr;
            HITSNode dataOut = new HITSNode();
            ArrayListOfIntsWritable links = new ArrayListOfIntsWritable();
            dataOut.setType(1);
            String line = value.toString();
            StringTokenizer itr = new StringTokenizer(line);
            if (itr.hasMoreTokens()) {
                curr = Integer.parseInt(itr.nextToken());
                if (this.stopList.contains(curr)) {
                    return;
                }
                this.keyOut.set(curr);
                dataOut.setNodeId(this.keyOut.get());
            }
            while (itr.hasMoreTokens()) {
                curr = Integer.parseInt(itr.nextToken());
                if (this.stopList.contains(curr)) continue;
                links.add(curr);
            }
            dataOut.setOutlinks(links);
            dataOut.setHRank(0.0f);
            System.out.println(">>>" + this.keyOut.get() + " | " + dataOut.toString());
            output.collect((Object)this.keyOut, (Object)dataOut);
        }
    }
}

