/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.hits;

import edu.umd.cloud9.io.array.ArrayListOfIntsWritable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class HITSNode
implements Writable {
    public static final int TYPE_HUB_COMPLETE = 1;
    public static final int TYPE_HUB_MASS = 3;
    public static final int TYPE_HUB_STRUCTURE = 5;
    public static final int TYPE_AUTH_COMPLETE = 2;
    public static final int TYPE_AUTH_MASS = 4;
    public static final int TYPE_AUTH_STRUCTURE = 6;
    public static final int TYPE_NODE_COMPLETE = 7;
    public static final int TYPE_NODE_MASS = 8;
    public static final int TYPE_NODE_STRUCTURE = 9;
    private int mType;
    private int mNodeId;
    private float mHRank;
    private float mARank;
    private ArrayListOfIntsWritable mInlinks = new ArrayListOfIntsWritable();
    private ArrayListOfIntsWritable mOutlinks = new ArrayListOfIntsWritable();

    public float getHRank() {
        return this.mHRank;
    }

    public float getARank() {
        return this.mARank;
    }

    public void setHRank(float r) {
        this.mHRank = r;
    }

    public void setARank(float r) {
        this.mARank = r;
    }

    public int getNodeId() {
        return this.mNodeId;
    }

    public void setNodeId(int n) {
        this.mNodeId = n;
    }

    public ArrayListOfIntsWritable getInlinks() {
        return this.mInlinks;
    }

    public void setInlinks(ArrayListOfIntsWritable l) {
        this.mInlinks = l;
    }

    public ArrayListOfIntsWritable getOutlinks() {
        return this.mOutlinks;
    }

    public void setOutlinks(ArrayListOfIntsWritable l) {
        this.mOutlinks = l;
    }

    public int getType() {
        return this.mType;
    }

    public void setType(int type) {
        if (type != 1 && type != 3 && type != 5 && type != 2 && type != 4 && type != 6 && type != 8 && type != 9 && type != 7) {
            return;
        }
        this.mType = type;
    }

    public void readFields(DataInput in) throws IOException {
        this.mType = in.readByte();
        this.mNodeId = in.readInt();
        this.mInlinks = new ArrayListOfIntsWritable();
        this.mOutlinks = new ArrayListOfIntsWritable();
        if (this.mType == 3 || this.mType == 8) {
            this.mHRank = in.readFloat();
            return;
        }
        if (this.mType == 4 || this.mType == 8) {
            this.mARank = in.readFloat();
            return;
        }
        if (this.mType == 1 || this.mType == 7) {
            this.mHRank = in.readFloat();
        }
        if (this.mType == 2 || this.mType == 7) {
            this.mARank = in.readFloat();
        }
        this.mInlinks.readFields(in);
        this.mOutlinks.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte((byte)this.mType);
        out.writeInt(this.mNodeId);
        if (this.mType == 3 || this.mType == 8) {
            out.writeFloat(this.mHRank);
            return;
        }
        if (this.mType == 4 || this.mType == 8) {
            out.writeFloat(this.mARank);
            return;
        }
        if (this.mType == 1 || this.mType == 7) {
            out.writeFloat(this.mHRank);
        }
        if (this.mType == 2 || this.mType == 7) {
            out.writeFloat(this.mARank);
        }
        this.mInlinks.write(out);
        this.mOutlinks.write(out);
    }

    public String toString() {
        int i;
        StringBuilder s = new StringBuilder();
        s.append("{");
        s.append(this.mNodeId);
        s.append(" ");
        if (this.mType == 1 || this.mType == 3 || this.mType == 5) {
            s.append("H");
        } else if (this.mType == 2 || this.mType == 4 || this.mType == 6) {
            s.append("A");
        } else if (this.mType == 7 || this.mType == 8 || this.mType == 9) {
            s.append("N");
        } else {
            s.append("?");
        }
        if (this.mType == 1 || this.mType == 3 || this.mType == 7) {
            s.append(" H: " + this.mHRank);
        }
        if (this.mType == 2 || this.mType == 4 || this.mType == 7) {
            s.append(" A: " + this.mARank);
        }
        s.append(" ");
        if (this.mOutlinks == null) {
            s.append("Out: {}");
        } else {
            s.append("Out: {");
            for (i = 0; i < this.mOutlinks.size(); ++i) {
                s.append(this.mOutlinks.get(i));
                if (i >= this.mOutlinks.size() - 1) continue;
                s.append(", ");
            }
            s.append("}");
        }
        s.append(" ");
        if (this.mInlinks == null) {
            s.append("In: {}");
        } else {
            s.append("In: {");
            for (i = 0; i < this.mInlinks.size(); ++i) {
                s.append(this.mInlinks.get(i));
                if (i >= this.mInlinks.size() - 1) continue;
                s.append(", ");
            }
            s.append("} ");
        }
        s.append("}");
        return s.toString();
    }
}

