/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.hits;

import edu.umd.cloud9.example.hits.HITSNode;
import edu.umd.cloud9.io.array.ArrayListOfIntsWritable;
import edu.umd.cloud9.util.map.HMapIV;
import edu.umd.cloud9.util.map.MapIV;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class InlinkCounter
extends Configured
implements Tool {
    private static final Logger sLogger = Logger.getLogger(InlinkCounter.class);

    private static int printUsage() {
        System.out.println("usage: [input-path] [output-path] [num-mappers] [num-reducers]");
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        return -1;
    }

    public int run(String[] args) throws Exception {
        if (args.length != 4) {
            InlinkCounter.printUsage();
            return -1;
        }
        String inputPath = args[0];
        String outputPath = args[1];
        int mapTasks = Integer.parseInt(args[2]);
        int reduceTasks = Integer.parseInt(args[3]);
        sLogger.info((Object)"Tool: Counter");
        sLogger.info((Object)(" - input path: " + inputPath));
        sLogger.info((Object)(" - output path: " + outputPath));
        sLogger.info((Object)(" - number of mappers: " + mapTasks));
        sLogger.info((Object)(" - number of reducers: " + reduceTasks));
        JobConf conf = new JobConf(InlinkCounter.class);
        conf.setJobName("InlinkCounter -- Web Graph");
        conf.setNumMapTasks(mapTasks);
        conf.setNumReduceTasks(reduceTasks);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{new Path(inputPath)});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(outputPath));
        FileOutputFormat.setCompressOutput((JobConf)conf, (boolean)false);
        conf.setOutputKeyClass(IntWritable.class);
        conf.setOutputValueClass(LongWritable.class);
        conf.setMapperClass(AFormatMapper.class);
        conf.setCombinerClass(AFormatCombiner.class);
        conf.setReducerClass(AFormatReducer.class);
        Path outputDir = new Path(outputPath);
        FileSystem.get((Configuration)conf).delete(outputDir, true);
        long startTime = System.currentTimeMillis();
        sLogger.info((Object)"Starting job");
        JobClient.runJob((JobConf)conf);
        sLogger.info((Object)("Job Finished in " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds"));
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new InlinkCounter(), (String[])args);
        System.exit(res);
    }

    private static class AFormatReducer
    extends MapReduceBase
    implements Reducer<IntWritable, LongWritable, IntWritable, LongWritable> {
        private LongWritable valIn;
        private LongWritable valOut = new LongWritable();
        ArrayListOfIntsWritable adjList = new ArrayListOfIntsWritable();

        private AFormatReducer() {
        }

        public void reduce(IntWritable key, Iterator<LongWritable> values, OutputCollector<IntWritable, LongWritable> output, Reporter reporter) throws IOException {
            long sum = 0L;
            while (values.hasNext()) {
                sum += values.next().get();
            }
            if (sum > 100000L) {
                this.valOut.set(sum);
                output.collect((Object)key, (Object)this.valOut);
            }
        }
    }

    private static class AFormatCombiner
    extends MapReduceBase
    implements Reducer<IntWritable, LongWritable, IntWritable, LongWritable> {
        private LongWritable valIn;
        private LongWritable valOut = new LongWritable();
        ArrayListOfIntsWritable adjList = new ArrayListOfIntsWritable();

        private AFormatCombiner() {
        }

        public void reduce(IntWritable key, Iterator<LongWritable> values, OutputCollector<IntWritable, LongWritable> output, Reporter reporter) throws IOException {
            long sum = 0L;
            while (values.hasNext()) {
                sum += values.next().get();
            }
            this.valOut.set(sum);
            output.collect((Object)key, (Object)this.valOut);
        }
    }

    private static class AFormatMapperIMC
    extends MapReduceBase
    implements Mapper<LongWritable, Text, IntWritable, HITSNode> {
        private HITSNode valOut = new HITSNode();
        private IntWritable keyOut = new IntWritable();
        private static OutputCollector<IntWritable, HITSNode> mOutput;
        private static HMapIV<ArrayListOfIntsWritable> adjLists;

        private AFormatMapperIMC() {
        }

        public void configure(JobConf jc) {
            adjLists.clear();
        }

        public void map(LongWritable key, Text value, OutputCollector<IntWritable, HITSNode> output, Reporter reporter) throws IOException {
            mOutput = output;
            ArrayListOfIntsWritable links = new ArrayListOfIntsWritable();
            String line = value.toString();
            StringTokenizer itr = new StringTokenizer(line);
            if (itr.hasMoreTokens()) {
                links.add(Integer.parseInt(itr.nextToken()));
            }
            while (itr.hasMoreTokens()) {
                int curr = Integer.parseInt(itr.nextToken());
                if (adjLists.containsKey(curr)) {
                    ArrayListOfIntsWritable list = adjLists.get(curr);
                    list.trimToSize();
                    links.trimToSize();
                    adjLists.put(curr, list);
                    continue;
                }
                links.trimToSize();
                adjLists.put(curr, links);
            }
        }

        public void close() throws IOException {
            for (MapIV.Entry<ArrayListOfIntsWritable> e : adjLists.entrySet()) {
                this.keyOut.set(e.getKey());
                this.valOut.setNodeId(e.getKey());
                this.valOut.setARank(0.0f);
                this.valOut.setHRank(0.0f);
                this.valOut.setType(2);
                mOutput.collect((Object)this.keyOut, (Object)this.valOut);
            }
        }

        static {
            adjLists = new HMapIV();
        }
    }

    private static class AFormatMapper
    extends MapReduceBase
    implements Mapper<LongWritable, Text, IntWritable, LongWritable> {
        private LongWritable valOut = new LongWritable(1L);
        private IntWritable keyOut = new IntWritable();

        private AFormatMapper() {
        }

        public void map(LongWritable key, Text value, OutputCollector<IntWritable, LongWritable> output, Reporter reporter) throws IOException {
            ArrayListOfIntsWritable links = new ArrayListOfIntsWritable();
            String line = value.toString();
            StringTokenizer itr = new StringTokenizer(line);
            if (itr.hasMoreTokens()) {
                itr.nextToken();
            }
            while (itr.hasMoreTokens()) {
                this.keyOut.set(Integer.parseInt(itr.nextToken()));
                output.collect((Object)this.keyOut, (Object)this.valOut);
            }
        }
    }
}

