/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.hits;

import edu.umd.cloud9.example.hits.HITSNode;
import edu.umd.cloud9.io.array.ArrayListOfIntsWritable;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class MergeFormattedRecords
extends Configured
implements Tool {
    private static final Logger sLogger = Logger.getLogger(MergeFormattedRecords.class);

    private static int printUsage() {
        System.out.println("usage: [hub-input-path] [auth-input-path] [output-path] [num-mappers] [num-reducers]");
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        return -1;
    }

    public int run(String[] args) throws Exception {
        if (args.length != 5) {
            MergeFormattedRecords.printUsage();
            return -1;
        }
        String hInputPath = args[0];
        String aInputPath = args[1];
        String outputPath = args[2];
        int mapTasks = Integer.parseInt(args[3]);
        int reduceTasks = Integer.parseInt(args[4]);
        sLogger.info((Object)"Tool: MergeFormattedRecords");
        sLogger.info((Object)(" - input paths: " + hInputPath + " " + aInputPath));
        sLogger.info((Object)(" - output path: " + outputPath));
        sLogger.info((Object)(" - number of mappers: " + mapTasks));
        sLogger.info((Object)(" - number of reducers: " + reduceTasks));
        JobConf conf = new JobConf(MergeFormattedRecords.class);
        conf.setJobName("HAMergeFormattedRecords");
        conf.setNumMapTasks(mapTasks);
        conf.setNumReduceTasks(reduceTasks);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{new Path(hInputPath)});
        FileInputFormat.addInputPath((JobConf)conf, (Path)new Path(aInputPath));
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(outputPath));
        FileOutputFormat.setCompressOutput((JobConf)conf, (boolean)false);
        conf.setInputFormat(SequenceFileInputFormat.class);
        conf.setOutputKeyClass(IntWritable.class);
        conf.setOutputValueClass(HITSNode.class);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        conf.setMapperClass(IdentityMapper.class);
        conf.setReducerClass(MergeReducer.class);
        Path outputDir = new Path(outputPath);
        FileSystem.get((Configuration)conf).delete(outputDir, true);
        long startTime = System.currentTimeMillis();
        JobClient.runJob((JobConf)conf);
        sLogger.info((Object)("Job Finished in " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds"));
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new MergeFormattedRecords(), (String[])args);
        System.exit(res);
    }

    private static class MergeReducer
    extends MapReduceBase
    implements Reducer<IntWritable, HITSNode, IntWritable, HITSNode> {
        private MergeReducer() {
        }

        public void reduce(IntWritable key, Iterator<HITSNode> values, OutputCollector<IntWritable, HITSNode> output, Reporter reporter) throws IOException {
            ArrayListOfIntsWritable adjList = new ArrayListOfIntsWritable();
            HITSNode nodeOut = new HITSNode();
            nodeOut.setType(7);
            nodeOut.setARank(0.0f);
            nodeOut.setInlinks(new ArrayListOfIntsWritable());
            nodeOut.setHRank(0.0f);
            nodeOut.setOutlinks(new ArrayListOfIntsWritable());
            nodeOut.setNodeId(key.get());
            while (values.hasNext()) {
                HITSNode nodeIn = values.next();
                if (nodeIn.getType() == 1) {
                    nodeOut.setHRank(nodeIn.getHRank());
                    nodeOut.setOutlinks(new ArrayListOfIntsWritable(nodeIn.getOutlinks()));
                }
                if (nodeIn.getType() != 2) continue;
                nodeOut.setARank(nodeIn.getARank());
                nodeOut.setInlinks(new ArrayListOfIntsWritable(nodeIn.getInlinks()));
            }
            output.collect((Object)key, (Object)nodeOut);
        }
    }
}

