/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.memcached;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.SocketAddress;
import java.util.Map;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.MemcachedClient;

public class GetStatus {
    private static String getListOfIpAddresses(String inputFile) {
        String ipAddresses = "";
        String port = "11211";
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(inputFile)));
            while ((line = in.readLine()) != null) {
                if (line.equals("")) continue;
                String temp = line + ":" + port;
                if (ipAddresses.equals("")) {
                    ipAddresses = temp;
                    continue;
                }
                ipAddresses = ipAddresses + " " + temp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ipAddresses;
    }

    public static void main(String[] args) throws IOException {
        String pathOfIpAddressFile;
        String ipAddress;
        if (args.length != 1) {
            System.out.println(" usage : [path of ip address file] [path of sequence file on dfs ]");
            System.exit(1);
        }
        if ((ipAddress = GetStatus.getListOfIpAddresses(pathOfIpAddressFile = args[0])).equals("")) {
            System.out.println("List of Memcache servers IP Addresses not available");
            System.exit(1);
        } else {
            System.out.println("List of IP addresses : " + ipAddress);
        }
        long total_items = 0L;
        MemcachedClient myMCC = new MemcachedClient(AddrUtil.getAddresses((String)ipAddress));
        Map stats = myMCC.getStats();
        for (Map.Entry e : stats.entrySet()) {
            System.out.println("memcached server: " + ((SocketAddress)e.getKey()).toString());
            for (Map.Entry s : ((Map)e.getValue()).entrySet()) {
                System.out.println(" - " + (String)s.getKey() + ": " + (String)s.getValue());
                if (!((String)s.getKey()).equals("curr_items")) continue;
                total_items += Long.parseLong((String)s.getValue());
            }
        }
        System.out.println("Total number items in memcache: " + total_items);
    }
}

