/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.memcached.demo;

import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.pig.data.Tuple;

public class GetLogProbFromHDFS {
    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.out.println(" usage : [path of sequence file on hdfs] [path of Map File on hdfs] [num of MapTasks]");
            System.exit(1);
        }
        String inputPath = args[0];
        String mapPath = args[1];
        int mapTasks = Integer.parseInt(args[2]);
        int reduceTasks = 0;
        String extraPath = "/shared/extraInfo";
        JobConf conf = new JobConf(GetLogProbFromHDFS.class);
        conf.setJobName("GetLogProbFromHDFS");
        conf.setNumMapTasks(mapTasks);
        conf.setNumReduceTasks(reduceTasks);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{new Path(inputPath)});
        conf.setInputFormat(SequenceFileInputFormat.class);
        conf.setMapOutputValueClass(FloatWritable.class);
        conf.setMapperClass(MyMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        conf.set("mapfileInputPath", mapPath);
        Path outputDir = new Path(extraPath);
        FileSystem.get((Configuration)conf).delete(outputDir, true);
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outputDir);
        JobClient.runJob((JobConf)conf);
    }

    private static class MyMapper
    extends MapReduceBase
    implements Mapper<LongWritable, Tuple, LongWritable, FloatWritable> {
        Long keyTemp = new Long(0L);
        Object obj;
        String inputPath;
        FileSystem fs;
        MapFile.Reader reader;

        private MyMapper() {
        }

        public void configure(JobConf conf) {
            try {
                this.inputPath = conf.get("mapfileInputPath");
                this.fs = FileSystem.get((Configuration)conf);
                this.reader = new MapFile.Reader(this.fs, this.inputPath, (Configuration)conf);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void map(LongWritable key, Tuple value, OutputCollector<LongWritable, FloatWritable> output, Reporter reporter) throws IOException {
            FloatWritable logProb = new FloatWritable();
            FloatWritable finalValue = new FloatWritable();
            String line = (String)value.get(0);
            StringTokenizer itr = new StringTokenizer(line);
            float sum = 0.0f;
            Text tempKey = new Text();
            while (itr.hasMoreTokens()) {
                String temp = itr.nextToken();
                tempKey.set(temp);
                long startTime = System.currentTimeMillis();
                this.reader.seek((WritableComparable)tempKey);
                this.reader.get((WritableComparable)tempKey, (Writable)logProb);
                long endTime = System.currentTimeMillis();
                long diff = endTime - startTime;
                reporter.incrCounter((Enum)MyCounters.TIME, diff);
                if (logProb == null) {
                    throw new RuntimeException("Error getting from memcache");
                }
                sum += logProb.get();
            }
            finalValue.set(sum);
            output.collect((Object)key, (Object)finalValue);
        }
    }

    static enum MyCounters {
        TIME;

    }
}

