/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.memcached.demo;

import java.io.IOException;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;

public class WordCount {
    protected WordCount() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 4) {
            System.out.println("usage: [input] [output] [num-mappers] [num-reducer]");
            System.exit(-1);
        }
        String inputPath = args[0];
        String outputPath = args[1];
        int mapTasks = Integer.parseInt(args[2]);
        int reduceTasks = Integer.parseInt(args[3]);
        JobConf conf = new JobConf(WordCount.class);
        conf.setJobName("WordCount");
        conf.setNumMapTasks(mapTasks);
        conf.setNumReduceTasks(reduceTasks);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{new Path(inputPath)});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(outputPath));
        FileOutputFormat.setCompressOutput((JobConf)conf, (boolean)false);
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(IntWritable.class);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        conf.setMapperClass(MyMapper.class);
        conf.setCombinerClass(MyReducer.class);
        conf.setReducerClass(MyReducer.class);
        Path outputDir = new Path(outputPath);
        FileSystem.get((Configuration)conf).delete(outputDir, true);
        JobClient.runJob((JobConf)conf);
    }

    public static class MyReducer
    extends MapReduceBase
    implements Reducer<Text, IntWritable, Text, IntWritable> {
        private static final IntWritable SumValue = new IntWritable();

        public void reduce(Text key, Iterator<IntWritable> values, OutputCollector<Text, IntWritable> output, Reporter reporter) throws IOException {
            int sum = 0;
            while (values.hasNext()) {
                sum += values.next().get();
            }
            SumValue.set(sum);
            output.collect((Object)key, (Object)SumValue);
        }
    }

    public static class MyMapper
    extends MapReduceBase
    implements Mapper<LongWritable, Text, Text, IntWritable> {
        private static final IntWritable one = new IntWritable(1);
        private Text word = new Text();

        public void map(LongWritable key, Text value, OutputCollector<Text, IntWritable> output, Reporter reporter) throws IOException {
            String line = value.toString();
            StringTokenizer itr = new StringTokenizer(line);
            while (itr.hasMoreTokens()) {
                this.word.set(itr.nextToken());
                output.collect((Object)this.word, (Object)one);
            }
        }
    }
}

