/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.pagerank;

import edu.umd.cloud9.example.pagerank.PageRankNode;
import edu.umd.cloud9.io.array.ArrayListOfIntsWritable;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class BuildPageRankRecords
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(BuildPageRankRecords.class);
    private static final String NODE_CNT_FIELD = "node.cnt";
    private static final String INPUT = "input";
    private static final String OUTPUT = "output";
    private static final String NUM_NODES = "numNodes";

    public int run(String[] args) throws Exception {
        CommandLine cmdline;
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"input path");
        options.addOption(OptionBuilder.create((String)INPUT));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"output path");
        options.addOption(OptionBuilder.create((String)OUTPUT));
        OptionBuilder.withArgName((String)"num");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"number of nodes");
        options.addOption(OptionBuilder.create((String)NUM_NODES));
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            return -1;
        }
        if (!(cmdline.hasOption(INPUT) && cmdline.hasOption(OUTPUT) && cmdline.hasOption(NUM_NODES))) {
            System.out.println("args: " + Arrays.toString(args));
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(120);
            formatter.printHelp(((Object)((Object)this)).getClass().getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        String inputPath = cmdline.getOptionValue(INPUT);
        String outputPath = cmdline.getOptionValue(OUTPUT);
        int n = Integer.parseInt(cmdline.getOptionValue(NUM_NODES));
        LOG.info((Object)("Tool name: " + BuildPageRankRecords.class.getSimpleName()));
        LOG.info((Object)(" - inputDir: " + inputPath));
        LOG.info((Object)(" - outputDir: " + outputPath));
        LOG.info((Object)(" - numNodes: " + n));
        Configuration conf = this.getConf();
        conf.setInt(NODE_CNT_FIELD, n);
        conf.setInt("mapred.min.split.size", 0x40000000);
        Job job = Job.getInstance((Configuration)conf);
        job.setJobName(BuildPageRankRecords.class.getSimpleName() + ":" + inputPath);
        job.setJarByClass(BuildPageRankRecords.class);
        job.setNumReduceTasks(0);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(inputPath));
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputPath));
        job.setInputFormatClass(TextInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(PageRankNode.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(PageRankNode.class);
        job.setMapperClass(MyMapper.class);
        FileSystem.get((Configuration)conf).delete(new Path(outputPath), true);
        job.waitForCompletion(true);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new BuildPageRankRecords(), (String[])args);
    }

    private static class MyMapper
    extends Mapper<LongWritable, Text, IntWritable, PageRankNode> {
        private static final IntWritable nid = new IntWritable();
        private static final PageRankNode node = new PageRankNode();

        private MyMapper() {
        }

        public void setup(Mapper.Context context) {
            int n = context.getConfiguration().getInt(BuildPageRankRecords.NODE_CNT_FIELD, 0);
            if (n == 0) {
                throw new RuntimeException("node.cnt cannot be 0!");
            }
            node.setType(PageRankNode.Type.Complete);
            node.setPageRank((float)(-StrictMath.log(n)));
        }

        public void map(LongWritable key, Text t, Mapper.Context context) throws IOException, InterruptedException {
            String[] arr = t.toString().trim().split("\\s+");
            nid.set(Integer.parseInt(arr[0]));
            if (arr.length == 1) {
                node.setNodeId(Integer.parseInt(arr[0]));
                node.setAdjacencyList(new ArrayListOfIntsWritable());
            } else {
                node.setNodeId(Integer.parseInt(arr[0]));
                int[] neighbors = new int[arr.length - 1];
                for (int i = 1; i < arr.length; ++i) {
                    neighbors[i - 1] = Integer.parseInt(arr[i]);
                }
                node.setAdjacencyList(new ArrayListOfIntsWritable(neighbors));
            }
            context.getCounter("graph", BuildPageRankRecords.NUM_NODES).increment(1L);
            context.getCounter("graph", "numEdges").increment((long)(arr.length - 1));
            if (arr.length > 1) {
                context.getCounter("graph", "numActiveNodes").increment(1L);
            }
            context.write((Object)nid, (Object)node);
        }
    }
}

