/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.pagerank;

import edu.umd.cloud9.example.pagerank.PageRankNode;
import edu.umd.cloud9.io.array.ArrayListOfIntsWritable;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class PageRankNodeTest {
    @org.junit.Test
    public void testSerialize() throws IOException {
        PageRankNode node1 = new PageRankNode();
        node1.setType(PageRankNode.Type.Complete);
        node1.setNodeId(1);
        node1.setPageRank(0.1f);
        node1.setAdjacencyList(new ArrayListOfIntsWritable(new int[]{1, 2, 3, 4, 5, 6}));
        byte[] bytes = node1.serialize();
        PageRankNode node2 = PageRankNode.create(bytes);
        Assert.assertEquals((double)0.1f, (double)node2.getPageRank(), (double)1.0E-5);
        Assert.assertEquals((Object)((Object)PageRankNode.Type.Complete), (Object)((Object)node2.getType()));
        ArrayListOfIntsWritable adj = node2.getAdjacenyList();
        Assert.assertEquals((long)6L, (long)adj.size());
        Assert.assertEquals((long)1L, (long)adj.get(0));
        Assert.assertEquals((long)2L, (long)adj.get(1));
        Assert.assertEquals((long)3L, (long)adj.get(2));
        Assert.assertEquals((long)4L, (long)adj.get(3));
        Assert.assertEquals((long)5L, (long)adj.get(4));
        Assert.assertEquals((long)6L, (long)adj.get(5));
    }

    @org.junit.Test
    public void testToString() throws Exception {
        PageRankNode node = new PageRankNode();
        node.setType(PageRankNode.Type.Complete);
        node.setNodeId(1);
        node.setPageRank(0.1f);
        Assert.assertEquals((Object)"{1 0.1000 []}", (Object)node.toString());
        node.setAdjacencyList(new ArrayListOfIntsWritable(new int[]{1, 2, 3, 4, 5, 6}));
        Assert.assertEquals((Object)"{1 0.1000 [1, 2, 3, 4, 5, 6]}", (Object)node.toString());
        node.setAdjacencyList(new ArrayListOfIntsWritable(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}));
        Assert.assertEquals((Object)"{1 0.1000 [1, 2, 3, 4, 5, 6, 7, 8, 9, 10 ... (2 more) ]}", (Object)node.toString());
    }

    public static Test suite() {
        return new JUnit4TestAdapter(PageRankNodeTest.class);
    }
}

