/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.pagerank;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import edu.umd.cloud9.example.pagerank.PageRankNode;
import edu.umd.cloud9.example.pagerank.RangePartitioner;
import edu.umd.cloud9.io.array.ArrayListOfIntsWritable;
import edu.umd.cloud9.mapreduce.lib.input.NonSplitableSequenceFileInputFormat;
import edu.umd.cloud9.util.map.HMapIF;
import edu.umd.cloud9.util.map.MapIF;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.mapreduce.lib.partition.HashPartitioner;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class RunPageRankSchimmy
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(RunPageRankSchimmy.class);
    private static float ALPHA = 0.15f;
    private static final NumberFormat FORMAT = new DecimalFormat("0000");
    private static final String BASE = "base";
    private static final String NUM_NODES = "numNodes";
    private static final String START = "start";
    private static final String END = "end";
    private static final String COMBINER = "useCombiner";
    private static final String INMAPPER_COMBINER = "useInMapperCombiner";
    private static final String RANGE = "range";

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new RunPageRankSchimmy(), (String[])args);
    }

    public int run(String[] args) throws Exception {
        CommandLine cmdline;
        Options options = new Options();
        options.addOption(new Option(COMBINER, "use combiner"));
        options.addOption(new Option(INMAPPER_COMBINER, "user in-mapper combiner"));
        options.addOption(new Option(RANGE, "use range partitioner"));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"base path");
        options.addOption(OptionBuilder.create((String)BASE));
        OptionBuilder.withArgName((String)"num");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"start iteration");
        options.addOption(OptionBuilder.create((String)START));
        OptionBuilder.withArgName((String)"num");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"end iteration");
        options.addOption(OptionBuilder.create((String)END));
        OptionBuilder.withArgName((String)"num");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"number of nodes");
        options.addOption(OptionBuilder.create((String)NUM_NODES));
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            return -1;
        }
        if (!(cmdline.hasOption(BASE) && cmdline.hasOption(START) && cmdline.hasOption(END) && cmdline.hasOption(NUM_NODES))) {
            System.out.println("args: " + Arrays.toString(args));
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(120);
            formatter.printHelp(((Object)((Object)this)).getClass().getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        String basePath = cmdline.getOptionValue(BASE);
        int n = Integer.parseInt(cmdline.getOptionValue(NUM_NODES));
        int s = Integer.parseInt(cmdline.getOptionValue(START));
        int e = Integer.parseInt(cmdline.getOptionValue(END));
        boolean useCombiner = cmdline.hasOption(COMBINER);
        boolean useInmapCombiner = cmdline.hasOption(INMAPPER_COMBINER);
        boolean useRange = cmdline.hasOption(RANGE);
        LOG.info((Object)"Tool name: RunPageRank");
        LOG.info((Object)(" - base path: " + basePath));
        LOG.info((Object)(" - num nodes: " + n));
        LOG.info((Object)(" - start iteration: " + s));
        LOG.info((Object)(" - end iteration: " + e));
        LOG.info((Object)(" - use combiner: " + useCombiner));
        LOG.info((Object)(" - use in-mapper combiner: " + useInmapCombiner));
        LOG.info((Object)(" - user range partitioner: " + useRange));
        for (int i = s; i < e; ++i) {
            this.iteratePageRank(basePath, i, i + 1, n, useCombiner, useInmapCombiner, useRange);
        }
        return 0;
    }

    private void iteratePageRank(String path, int i, int j, int n, boolean useCombiner, boolean useInmapCombiner, boolean useRange) throws Exception {
        float mass = this.phase1(path, i, j, n, useCombiner, useInmapCombiner, useRange);
        float missing = 1.0f - (float)StrictMath.exp(mass);
        if (missing < 0.0f) {
            missing = 0.0f;
        }
        this.phase2(path, i, j, n, missing);
    }

    private float phase1(String path, int i, int j, int n, boolean useCombiner, boolean useInmapCombiner, boolean useRange) throws Exception {
        Configuration conf = this.getConf();
        String in = path + "/iter" + FORMAT.format(i);
        String out = path + "/iter" + FORMAT.format(j) + "t";
        String outm = out + "-mass";
        FileSystem fs = FileSystem.get((Configuration)conf);
        int numPartitions = 0;
        for (FileStatus s : FileSystem.get((Configuration)conf).listStatus(new Path(in))) {
            if (!s.getPath().getName().contains("part-")) continue;
            ++numPartitions;
        }
        conf.setInt("NodeCount", n);
        RangePartitioner p = null;
        if (useRange) {
            p = new RangePartitioner();
            ((Configurable)p).setConf(conf);
        } else {
            p = new HashPartitioner();
        }
        IntWritable key = new IntWritable();
        PageRankNode value = new PageRankNode();
        FileStatus[] status = fs.listStatus(new Path(in));
        StringBuilder sb = new StringBuilder();
        for (FileStatus f : status) {
            if (!f.getPath().getName().contains("part-")) continue;
            SequenceFile.Reader reader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)f.getPath())});
            reader.next((Writable)key, (Writable)value);
            int np = p.getPartition(key, value, numPartitions);
            reader.close();
            LOG.info((Object)(f.getPath() + "\t" + np));
            sb.append(np + "=" + f.getPath() + ";");
        }
        LOG.info((Object)sb.toString().trim());
        LOG.info((Object)("PageRankSchimmy: iteration " + j + ": Phase1"));
        LOG.info((Object)(" - input: " + in));
        LOG.info((Object)(" - output: " + out));
        LOG.info((Object)(" - nodeCnt: " + n));
        LOG.info((Object)(" - useCombiner: " + useCombiner));
        LOG.info((Object)(" - useInmapCombiner: " + useInmapCombiner));
        LOG.info((Object)(" - numPartitions: " + numPartitions));
        LOG.info((Object)(" - useRange: " + useRange));
        LOG.info((Object)("computed number of partitions: " + numPartitions));
        int numReduceTasks = numPartitions;
        conf.setInt("mapred.min.split.size", 0x40000000);
        conf.set("PageRankMassPath", outm);
        conf.set("BasePath", in);
        conf.set("PartitionMapping", sb.toString().trim());
        conf.setBoolean("mapred.map.tasks.speculative.execution", false);
        conf.setBoolean("mapred.reduce.tasks.speculative.execution", false);
        Job job = Job.getInstance((Configuration)conf);
        job.setJobName("PageRankSchimmy:iteration" + j + ":Phase1");
        job.setJarByClass(RunPageRankSchimmy.class);
        job.setNumReduceTasks(numReduceTasks);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(in)});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(out));
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(FloatWritable.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(PageRankNode.class);
        if (useInmapCombiner) {
            job.setMapperClass(MapWithInMapperCombiningClass.class);
        } else {
            job.setMapperClass(MapClass.class);
        }
        if (useCombiner) {
            job.setCombinerClass(CombineClass.class);
        }
        if (useRange) {
            job.setPartitionerClass(RangePartitioner.class);
        }
        job.setReducerClass(ReduceClass.class);
        FileSystem.get((Configuration)conf).delete(new Path(out), true);
        FileSystem.get((Configuration)conf).delete(new Path(outm), true);
        long startTime = System.currentTimeMillis();
        job.waitForCompletion(true);
        System.out.println("Job Finished in " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
        float mass = Float.NEGATIVE_INFINITY;
        for (FileStatus f : fs.listStatus(new Path(outm))) {
            FSDataInputStream fin = fs.open(f.getPath());
            mass = RunPageRankSchimmy.sumLogProbs(mass, fin.readFloat());
            fin.close();
        }
        return mass;
    }

    private void phase2(String path, int i, int j, int n, float missing) throws Exception {
        Configuration conf = this.getConf();
        LOG.info((Object)("missing PageRank mass: " + missing));
        LOG.info((Object)("number of nodes: " + n));
        String in = path + "/iter" + FORMAT.format(j) + "t";
        String out = path + "/iter" + FORMAT.format(j);
        LOG.info((Object)("PageRankSchimmy: iteration " + j + ": Phase2"));
        LOG.info((Object)(" - input: " + in));
        LOG.info((Object)(" - output: " + out));
        Job job = Job.getInstance((Configuration)conf);
        job.setJobName("PageRankSchimmy:iteration" + j + ":Phase2");
        job.setJarByClass(RunPageRankSchimmy.class);
        job.setNumReduceTasks(0);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(in)});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(out));
        job.setInputFormatClass(NonSplitableSequenceFileInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(PageRankNode.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(PageRankNode.class);
        job.setMapperClass(MapPageRankMassDistributionClass.class);
        conf.setFloat("MissingMass", missing);
        conf.setInt("NodeCount", n);
        FileSystem.get((Configuration)conf).delete(new Path(out), true);
        long startTime = System.currentTimeMillis();
        job.waitForCompletion(true);
        System.out.println("Job Finished in " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
    }

    private static float sumLogProbs(float a, float b) {
        if (a == Float.NEGATIVE_INFINITY) {
            return b;
        }
        if (b == Float.NEGATIVE_INFINITY) {
            return a;
        }
        if (a < b) {
            return (float)((double)b + StrictMath.log1p(StrictMath.exp(a - b)));
        }
        return (float)((double)a + StrictMath.log1p(StrictMath.exp(b - a)));
    }

    private static class MapPageRankMassDistributionClass
    extends Mapper<IntWritable, PageRankNode, IntWritable, PageRankNode> {
        private float missingMass = 0.0f;
        private int nodeCnt = 0;

        private MapPageRankMassDistributionClass() {
        }

        public void setup(Mapper.Context context) throws IOException {
            Configuration conf = context.getConfiguration();
            this.missingMass = conf.getFloat("MissingMass", 0.0f);
            this.nodeCnt = conf.getInt("NodeCount", 0);
        }

        public void map(IntWritable nid, PageRankNode node, Mapper.Context context) throws IOException, InterruptedException {
            float p = node.getPageRank();
            float jump = (float)(Math.log(ALPHA) - Math.log(this.nodeCnt));
            float link = (float)Math.log(1.0f - ALPHA) + RunPageRankSchimmy.sumLogProbs(p, (float)(Math.log(this.missingMass) - Math.log(this.nodeCnt)));
            p = RunPageRankSchimmy.sumLogProbs(jump, link);
            node.setPageRank(p);
            context.write((Object)nid, (Object)node);
        }
    }

    private static class ReduceClass
    extends Reducer<IntWritable, FloatWritable, IntWritable, PageRankNode> {
        private float totalMass = Float.NEGATIVE_INFINITY;
        private SequenceFile.Reader reader;
        private IntWritable hdfsNid = new IntWritable();
        private PageRankNode hdfsNode = new PageRankNode();
        private boolean hdfsAhead = false;

        private ReduceClass() {
        }

        public void setup(Reducer.Context context) throws IOException {
            Configuration conf = context.getConfiguration();
            String taskId = conf.get("mapred.task.id");
            Preconditions.checkNotNull((Object)taskId);
            String mapping = conf.get("PartitionMapping");
            Preconditions.checkNotNull((Object)mapping);
            HashMap map = Maps.newHashMap();
            for (String s : mapping.split(";")) {
                String[] arr = s.split("=");
                LOG.info((Object)(arr[0] + "\t" + arr[1]));
                map.put(Integer.parseInt(arr[0]), arr[1]);
            }
            int partno = Integer.parseInt(taskId.substring(taskId.length() - 7, taskId.length() - 2));
            String f = (String)map.get(partno);
            LOG.info((Object)("task id: " + taskId));
            LOG.info((Object)("partno: " + partno));
            LOG.info((Object)("file: " + f));
            try {
                this.reader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)new Path(f))});
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't open " + f + " for partno: " + partno + " within: " + taskId);
            }
        }

        public void reduce(IntWritable nid, Iterable<FloatWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            if (this.hdfsNid.get() > nid.get()) {
                return;
            }
            if (this.hdfsNid.get() < nid.get()) {
                if (this.hdfsAhead) {
                    this.hdfsNode.setPageRank(Float.NEGATIVE_INFINITY);
                    context.write((Object)this.hdfsNid, (Object)this.hdfsNode);
                    this.hdfsAhead = false;
                }
                while (this.reader.next((Writable)this.hdfsNid, (Writable)this.hdfsNode) && this.hdfsNid.get() != nid.get()) {
                    if (this.hdfsNid.get() > nid.get()) {
                        this.hdfsAhead = true;
                        return;
                    }
                    this.hdfsNode.setPageRank(Float.NEGATIVE_INFINITY);
                    context.write((Object)this.hdfsNid, (Object)this.hdfsNode);
                }
                if (this.hdfsNid.get() != nid.get()) {
                    return;
                }
            }
            int massMessagesReceived = 0;
            float mass = Float.NEGATIVE_INFINITY;
            for (FloatWritable f : values) {
                float n = f.get();
                ++massMessagesReceived;
                mass = RunPageRankSchimmy.sumLogProbs(mass, n);
            }
            this.totalMass = RunPageRankSchimmy.sumLogProbs(this.totalMass, mass);
            this.hdfsNode.setPageRank(mass);
            context.write((Object)nid, (Object)this.hdfsNode);
            context.getCounter((Enum)PageRank.massMessagesReceived).increment((long)massMessagesReceived);
            this.hdfsAhead = false;
        }

        public void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            String taskId = conf.get("mapred.task.id");
            String path = conf.get("PageRankMassPath");
            Preconditions.checkNotNull((Object)taskId);
            Preconditions.checkNotNull((Object)path);
            FileSystem fs = FileSystem.get((Configuration)conf);
            FSDataOutputStream out = fs.create(new Path(path + "/" + taskId), false);
            out.writeFloat(this.totalMass);
            out.close();
            if (this.hdfsAhead) {
                this.hdfsNode.setPageRank(Float.NEGATIVE_INFINITY);
                context.write((Object)this.hdfsNid, (Object)this.hdfsNode);
                this.hdfsAhead = false;
            }
            while (this.reader.next((Writable)this.hdfsNid, (Writable)this.hdfsNode)) {
                this.hdfsNode.setPageRank(Float.NEGATIVE_INFINITY);
                context.write((Object)this.hdfsNid, (Object)this.hdfsNode);
            }
            this.reader.close();
        }
    }

    private static class CombineClass
    extends Reducer<IntWritable, FloatWritable, IntWritable, FloatWritable> {
        private static final FloatWritable intermediateMass = new FloatWritable();

        private CombineClass() {
        }

        public void reduce(IntWritable nid, Iterable<FloatWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int massMessages = 0;
            float mass = Float.NEGATIVE_INFINITY;
            for (FloatWritable n : values) {
                mass = RunPageRankSchimmy.sumLogProbs(mass, n.get());
                ++massMessages;
            }
            if (massMessages > 0) {
                intermediateMass.set(mass);
                context.write((Object)nid, (Object)intermediateMass);
            }
        }
    }

    private static class MapWithInMapperCombiningClass
    extends Mapper<IntWritable, PageRankNode, IntWritable, FloatWritable> {
        private static HMapIF map = new HMapIF();

        private MapWithInMapperCombiningClass() {
        }

        public void map(IntWritable nid, PageRankNode node, Mapper.Context context) throws IOException, InterruptedException {
            int massMessages = 0;
            int massMessagesSaved = 0;
            if (node.getAdjacenyList().size() > 0) {
                ArrayListOfIntsWritable list = node.getAdjacenyList();
                float mass = node.getPageRank() - (float)StrictMath.log(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    int neighbor = list.get(i);
                    if (map.containsKey(neighbor)) {
                        ++massMessagesSaved;
                        map.put(neighbor, RunPageRankSchimmy.sumLogProbs(MapWithInMapperCombiningClass.map.get(neighbor), mass));
                        continue;
                    }
                    ++massMessages;
                    map.put(neighbor, mass);
                }
            }
            context.getCounter((Enum)PageRank.nodes).increment(1L);
            context.getCounter((Enum)PageRank.massMessages).increment((long)massMessages);
            context.getCounter((Enum)PageRank.massMessagesSaved).increment((long)massMessagesSaved);
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            IntWritable k = new IntWritable();
            FloatWritable v = new FloatWritable();
            for (MapIF.Entry e : map.entrySet()) {
                k.set(e.getKey());
                v.set(e.getValue());
                context.write((Object)k, (Object)v);
            }
        }
    }

    private static class MapClass
    extends Mapper<IntWritable, PageRankNode, IntWritable, FloatWritable> {
        private static final IntWritable neighbor = new IntWritable();
        private static final FloatWritable intermediateMass = new FloatWritable();

        private MapClass() {
        }

        public void map(IntWritable nid, PageRankNode node, Mapper.Context context) throws IOException, InterruptedException {
            int massMessages = 0;
            if (node.getAdjacenyList().size() > 0) {
                ArrayListOfIntsWritable list = node.getAdjacenyList();
                float mass = node.getPageRank() - (float)StrictMath.log(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    neighbor.set(list.get(i));
                    intermediateMass.set(mass);
                    context.write((Object)neighbor, (Object)intermediateMass);
                    ++massMessages;
                }
            }
            context.getCounter((Enum)PageRank.nodes).increment(1L);
            context.getCounter((Enum)PageRank.massMessages).increment((long)massMessages);
        }
    }

    private static enum PageRank {
        nodes,
        edges,
        massMessages,
        massMessagesSaved,
        massMessagesReceived,
        missingStructure;

    }
}

